/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackInstancesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListStackInstancesRequest.Builder, ListStackInstancesRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStackInstancesRequest::stackSetName)).setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStackInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListStackInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> STACK_INSTANCE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStackInstancesRequest::stackInstanceAccount)).setter(setter(Builder::stackInstanceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceAccount").build())
            .build();

    private static final SdkField<String> STACK_INSTANCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStackInstancesRequest::stackInstanceRegion)).setter(setter(Builder::stackInstanceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STACK_INSTANCE_ACCOUNT_FIELD, STACK_INSTANCE_REGION_FIELD));

    private final String stackSetName;

    private final String nextToken;

    private final Integer maxResults;

    private final String stackInstanceAccount;

    private final String stackInstanceRegion;

    private ListStackInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.stackInstanceAccount = builder.stackInstanceAccount;
        this.stackInstanceRegion = builder.stackInstanceRegion;
    }

    /**
     * <p>
     * The name or unique ID of the stack set that you want to list stack instances for.
     * </p>
     * 
     * @return The name or unique ID of the stack set that you want to list stack instances for.
     */
    public String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * If the previous request didn't return all of the remaining results, the response's <code>NextToken</code>
     * parameter value is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code>
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous request didn't return all of the remaining results, the response's <code>NextToken</code>
     *         parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListStackInstances</code> again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If there are no remaining results, the previous response object's
     *         <code>NextToken</code> parameter is set to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the AWS account that you want to list stack instances for.
     * </p>
     * 
     * @return The name of the AWS account that you want to list stack instances for.
     */
    public String stackInstanceAccount() {
        return stackInstanceAccount;
    }

    /**
     * <p>
     * The name of the Region where you want to list stack instances.
     * </p>
     * 
     * @return The name of the Region where you want to list stack instances.
     */
    public String stackInstanceRegion() {
        return stackInstanceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstancesRequest)) {
            return false;
        }
        ListStackInstancesRequest other = (ListStackInstancesRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(stackInstanceAccount(), other.stackInstanceAccount())
                && Objects.equals(stackInstanceRegion(), other.stackInstanceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStackInstancesRequest").add("StackSetName", stackSetName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("StackInstanceAccount", stackInstanceAccount())
                .add("StackInstanceRegion", stackInstanceRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StackInstanceAccount":
            return Optional.ofNullable(clazz.cast(stackInstanceAccount()));
        case "StackInstanceRegion":
            return Optional.ofNullable(clazz.cast(stackInstanceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackInstancesRequest, T> g) {
        return obj -> g.apply((ListStackInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStackInstancesRequest> {
        /**
         * <p>
         * The name or unique ID of the stack set that you want to list stack instances for.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set that you want to list stack instances for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * If the previous request didn't return all of the remaining results, the response's <code>NextToken</code>
         * parameter value is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code>
         * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous request didn't return all of the remaining results, the response's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListStackInstances</code> again and assign that token to the request object's
         *        <code>NextToken</code> parameter. If there are no remaining results, the previous response object's
         *        <code>NextToken</code> parameter is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the AWS account that you want to list stack instances for.
         * </p>
         * 
         * @param stackInstanceAccount
         *        The name of the AWS account that you want to list stack instances for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceAccount(String stackInstanceAccount);

        /**
         * <p>
         * The name of the Region where you want to list stack instances.
         * </p>
         * 
         * @param stackInstanceRegion
         *        The name of the Region where you want to list stack instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceRegion(String stackInstanceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String nextToken;

        private Integer maxResults;

        private String stackInstanceAccount;

        private String stackInstanceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackInstancesRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            stackInstanceAccount(model.stackInstanceAccount);
            stackInstanceRegion(model.stackInstanceRegion);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getStackInstanceAccount() {
            return stackInstanceAccount;
        }

        @Override
        public final Builder stackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
            return this;
        }

        public final void setStackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
        }

        public final String getStackInstanceRegion() {
            return stackInstanceRegion;
        }

        @Override
        public final Builder stackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
            return this;
        }

        public final void setStackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStackInstancesRequest build() {
            return new ListStackInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
