/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CfnRegistryException;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreatedButModifiedException;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.InsufficientCapabilitiesException;
import software.amazon.awssdk.services.cloudformation.model.InvalidChangeSetStatusException;
import software.amazon.awssdk.services.cloudformation.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudformation.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.cloudformation.model.LimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.NameAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationIdAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationInProgressException;
import software.amazon.awssdk.services.cloudformation.model.OperationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.OperationStatusCheckFailedException;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotEmptyException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StaleRequestException;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.TokenAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeregisterTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackDriftDetectionStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackInstanceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceDriftsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeTypeRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackResourceDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackSetDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypeRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypeVersionsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RecordHandlerProgressRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RegisterTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetTypeDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StopStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateTerminationProtectionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateRequestMarshaller;

@SdkInternalApi
final class DefaultCloudFormationClient
implements CloudFormationClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFormationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "cloudformation";
    }

    @Override
    public CancelUpdateStackResponse cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CancelUpdateStackResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CancelUpdateStackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelUpdateStack").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelUpdateStackRequest).withMarshaller((Marshaller)new CancelUpdateStackRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ContinueUpdateRollbackResponse continueUpdateRollback(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ContinueUpdateRollbackResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ContinueUpdateRollbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ContinueUpdateRollback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)continueUpdateRollbackRequest).withMarshaller((Marshaller)new ContinueUpdateRollbackRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateChangeSetResponse createChangeSet(CreateChangeSetRequest createChangeSetRequest) throws AlreadyExistsException, InsufficientCapabilitiesException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateChangeSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChangeSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createChangeSetRequest).withMarshaller((Marshaller)new CreateChangeSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException, AlreadyExistsException, TokenAlreadyExistsException, InsufficientCapabilitiesException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStackResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateStackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStack").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStackRequest).withMarshaller((Marshaller)new CreateStackRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStackInstancesResponse createStackInstances(CreateStackInstancesRequest createStackInstancesRequest) throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStackInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStackInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStackInstancesRequest).withMarshaller((Marshaller)new CreateStackInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStackSetResponse createStackSet(CreateStackSetRequest createStackSetRequest) throws NameAlreadyExistsException, CreatedButModifiedException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStackSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStackSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStackSetRequest).withMarshaller((Marshaller)new CreateStackSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteChangeSetResponse deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) throws InvalidChangeSetStatusException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteChangeSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChangeSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteChangeSetRequest).withMarshaller((Marshaller)new DeleteChangeSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteStackResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteStackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStack").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStackRequest).withMarshaller((Marshaller)new DeleteStackRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteStackInstancesResponse deleteStackInstances(DeleteStackInstancesRequest deleteStackInstancesRequest) throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteStackInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStackInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStackInstancesRequest).withMarshaller((Marshaller)new DeleteStackInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteStackSetResponse deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) throws StackSetNotEmptyException, OperationInProgressException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteStackSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStackSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStackSetRequest).withMarshaller((Marshaller)new DeleteStackSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeregisterTypeResponse deregisterType(DeregisterTypeRequest deregisterTypeRequest) throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterTypeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeregisterTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterTypeRequest).withMarshaller((Marshaller)new DeregisterTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeChangeSetResponse describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeChangeSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeChangeSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeChangeSetRequest).withMarshaller((Marshaller)new DescribeChangeSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackDriftDetectionStatusResponse describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackDriftDetectionStatusResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackDriftDetectionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackDriftDetectionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackDriftDetectionStatusRequest).withMarshaller((Marshaller)new DescribeStackDriftDetectionStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackEventsResponse describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackEventsRequest).withMarshaller((Marshaller)new DescribeStackEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackEventsIterable describeStackEventsPaginator(DescribeStackEventsRequest describeStackEventsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new DescribeStackEventsIterable(this, this.applyPaginatorUserAgent(describeStackEventsRequest));
    }

    @Override
    public DescribeStackInstanceResponse describeStackInstance(DescribeStackInstanceRequest describeStackInstanceRequest) throws StackSetNotFoundException, StackInstanceNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackInstanceRequest).withMarshaller((Marshaller)new DescribeStackInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackResourceResponse describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackResourceRequest).withMarshaller((Marshaller)new DescribeStackResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackResourceDriftsResponse describeStackResourceDrifts(DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackResourceDriftsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackResourceDriftsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackResourceDrifts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackResourceDriftsRequest).withMarshaller((Marshaller)new DescribeStackResourceDriftsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackResourceDriftsIterable describeStackResourceDriftsPaginator(DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new DescribeStackResourceDriftsIterable(this, this.applyPaginatorUserAgent(describeStackResourceDriftsRequest));
    }

    @Override
    public DescribeStackResourcesResponse describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackResourcesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackResourcesRequest).withMarshaller((Marshaller)new DescribeStackResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackSetResponse describeStackSet(DescribeStackSetRequest describeStackSetRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackSetRequest).withMarshaller((Marshaller)new DescribeStackSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStackSetOperationResponse describeStackSetOperation(DescribeStackSetOperationRequest describeStackSetOperationRequest) throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStackSetOperationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStackSetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStackSetOperation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStackSetOperationRequest).withMarshaller((Marshaller)new DescribeStackSetOperationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStacksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeStacksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStacks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStacksRequest).withMarshaller((Marshaller)new DescribeStacksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStacksIterable describeStacksPaginator(DescribeStacksRequest describeStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new DescribeStacksIterable(this, this.applyPaginatorUserAgent(describeStacksRequest));
    }

    @Override
    public DescribeTypeResponse describeType(DescribeTypeRequest describeTypeRequest) throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTypeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTypeRequest).withMarshaller((Marshaller)new DescribeTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTypeRegistrationResponse describeTypeRegistration(DescribeTypeRegistrationRequest describeTypeRegistrationRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTypeRegistrationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTypeRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTypeRegistration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTypeRegistrationRequest).withMarshaller((Marshaller)new DescribeTypeRegistrationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectStackDriftResponse detectStackDrift(DetectStackDriftRequest detectStackDriftRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetectStackDriftResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetectStackDriftResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectStackDrift").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectStackDriftRequest).withMarshaller((Marshaller)new DetectStackDriftRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectStackResourceDriftResponse detectStackResourceDrift(DetectStackResourceDriftRequest detectStackResourceDriftRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetectStackResourceDriftResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetectStackResourceDriftResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectStackResourceDrift").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectStackResourceDriftRequest).withMarshaller((Marshaller)new DetectStackResourceDriftRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectStackSetDriftResponse detectStackSetDrift(DetectStackSetDriftRequest detectStackSetDriftRequest) throws InvalidOperationException, OperationInProgressException, StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetectStackSetDriftResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetectStackSetDriftResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectStackSetDrift").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectStackSetDriftRequest).withMarshaller((Marshaller)new DetectStackSetDriftRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EstimateTemplateCostResponse estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EstimateTemplateCostResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EstimateTemplateCostResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EstimateTemplateCost").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)estimateTemplateCostRequest).withMarshaller((Marshaller)new EstimateTemplateCostRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ExecuteChangeSetResponse executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) throws InvalidChangeSetStatusException, ChangeSetNotFoundException, InsufficientCapabilitiesException, TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExecuteChangeSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ExecuteChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteChangeSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeChangeSetRequest).withMarshaller((Marshaller)new ExecuteChangeSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetStackPolicyResponse getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetStackPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetStackPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStackPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getStackPolicyRequest).withMarshaller((Marshaller)new GetStackPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemplateRequest).withMarshaller((Marshaller)new GetTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTemplateSummaryResponse getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTemplateSummaryResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetTemplateSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplateSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemplateSummaryRequest).withMarshaller((Marshaller)new GetTemplateSummaryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListChangeSetsResponse listChangeSets(ListChangeSetsRequest listChangeSetsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListChangeSetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListChangeSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChangeSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChangeSetsRequest).withMarshaller((Marshaller)new ListChangeSetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListExportsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExportsRequest).withMarshaller((Marshaller)new ListExportsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListExportsIterable(this, this.applyPaginatorUserAgent(listExportsRequest));
    }

    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListImportsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listImportsRequest).withMarshaller((Marshaller)new ListImportsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListImportsIterable(this, this.applyPaginatorUserAgent(listImportsRequest));
    }

    @Override
    public ListStackInstancesResponse listStackInstances(ListStackInstancesRequest listStackInstancesRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStackInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStackInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStackInstancesRequest).withMarshaller((Marshaller)new ListStackInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStackResourcesResponse listStackResources(ListStackResourcesRequest listStackResourcesRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStackResourcesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStackResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStackResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStackResourcesRequest).withMarshaller((Marshaller)new ListStackResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStackResourcesIterable listStackResourcesPaginator(ListStackResourcesRequest listStackResourcesRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListStackResourcesIterable(this, this.applyPaginatorUserAgent(listStackResourcesRequest));
    }

    @Override
    public ListStackSetOperationResultsResponse listStackSetOperationResults(ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStackSetOperationResultsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStackSetOperationResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStackSetOperationResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStackSetOperationResultsRequest).withMarshaller((Marshaller)new ListStackSetOperationResultsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStackSetOperationsResponse listStackSetOperations(ListStackSetOperationsRequest listStackSetOperationsRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStackSetOperationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStackSetOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStackSetOperations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStackSetOperationsRequest).withMarshaller((Marshaller)new ListStackSetOperationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStackSetsResponse listStackSets(ListStackSetsRequest listStackSetsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStackSetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStackSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStackSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStackSetsRequest).withMarshaller((Marshaller)new ListStackSetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStacksResponse listStacks(ListStacksRequest listStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStacksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStacksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStacks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStacksRequest).withMarshaller((Marshaller)new ListStacksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStacksIterable listStacksPaginator(ListStacksRequest listStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListStacksIterable(this, this.applyPaginatorUserAgent(listStacksRequest));
    }

    @Override
    public ListTypeRegistrationsResponse listTypeRegistrations(ListTypeRegistrationsRequest listTypeRegistrationsRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTypeRegistrationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTypeRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypeRegistrations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTypeRegistrationsRequest).withMarshaller((Marshaller)new ListTypeRegistrationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTypeRegistrationsIterable listTypeRegistrationsPaginator(ListTypeRegistrationsRequest listTypeRegistrationsRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return new ListTypeRegistrationsIterable(this, this.applyPaginatorUserAgent(listTypeRegistrationsRequest));
    }

    @Override
    public ListTypeVersionsResponse listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTypeVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTypeVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypeVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTypeVersionsRequest).withMarshaller((Marshaller)new ListTypeVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTypeVersionsIterable listTypeVersionsPaginator(ListTypeVersionsRequest listTypeVersionsRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return new ListTypeVersionsIterable(this, this.applyPaginatorUserAgent(listTypeVersionsRequest));
    }

    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTypesRequest).withMarshaller((Marshaller)new ListTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTypesIterable listTypesPaginator(ListTypesRequest listTypesRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return new ListTypesIterable(this, this.applyPaginatorUserAgent(listTypesRequest));
    }

    @Override
    public RecordHandlerProgressResponse recordHandlerProgress(RecordHandlerProgressRequest recordHandlerProgressRequest) throws InvalidStateTransitionException, OperationStatusCheckFailedException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RecordHandlerProgressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RecordHandlerProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordHandlerProgress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recordHandlerProgressRequest).withMarshaller((Marshaller)new RecordHandlerProgressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RegisterTypeResponse registerType(RegisterTypeRequest registerTypeRequest) throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterTypeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RegisterTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerTypeRequest).withMarshaller((Marshaller)new RegisterTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetStackPolicyResponse setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetStackPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetStackPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetStackPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setStackPolicyRequest).withMarshaller((Marshaller)new SetStackPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetTypeDefaultVersionResponse setTypeDefaultVersion(SetTypeDefaultVersionRequest setTypeDefaultVersionRequest) throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetTypeDefaultVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetTypeDefaultVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetTypeDefaultVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setTypeDefaultVersionRequest).withMarshaller((Marshaller)new SetTypeDefaultVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SignalResourceResponse signalResource(SignalResourceRequest signalResourceRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SignalResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SignalResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SignalResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)signalResourceRequest).withMarshaller((Marshaller)new SignalResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopStackSetOperationResponse stopStackSetOperation(StopStackSetOperationRequest stopStackSetOperationRequest) throws StackSetNotFoundException, OperationNotFoundException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopStackSetOperationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (StopStackSetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStackSetOperation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopStackSetOperationRequest).withMarshaller((Marshaller)new StopStackSetOperationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws InsufficientCapabilitiesException, TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateStackResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateStackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStack").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStackRequest).withMarshaller((Marshaller)new UpdateStackRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateStackInstancesResponse updateStackInstances(UpdateStackInstancesRequest updateStackInstancesRequest) throws StackSetNotFoundException, StackInstanceNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateStackInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStackInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStackInstancesRequest).withMarshaller((Marshaller)new UpdateStackInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateStackSetResponse updateStackSet(UpdateStackSetRequest updateStackSetRequest) throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, StackInstanceNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateStackSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStackSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStackSetRequest).withMarshaller((Marshaller)new UpdateStackSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateTerminationProtectionResponse updateTerminationProtection(UpdateTerminationProtectionRequest updateTerminationProtectionRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTerminationProtectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateTerminationProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTerminationProtection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTerminationProtectionRequest).withMarshaller((Marshaller)new UpdateTerminationProtectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ValidateTemplateResponse validateTemplate(ValidateTemplateRequest validateTemplateRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ValidateTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ValidateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateTemplateRequest).withMarshaller((Marshaller)new ValidateTemplateRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOperationException").exceptionBuilderSupplier(InvalidOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TokenAlreadyExistsException").exceptionBuilderSupplier(TokenAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CFNRegistryException").exceptionBuilderSupplier(CfnRegistryException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConditionalCheckFailed").exceptionBuilderSupplier(OperationStatusCheckFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NameAlreadyExistsException").exceptionBuilderSupplier(NameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotFoundException").exceptionBuilderSupplier(OperationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StackSetNotFoundException").exceptionBuilderSupplier(StackSetNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCapabilitiesException").exceptionBuilderSupplier(InsufficientCapabilitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationInProgressException").exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StaleRequestException").exceptionBuilderSupplier(StaleRequestException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidChangeSetStatus").exceptionBuilderSupplier(InvalidChangeSetStatusException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StackSetNotEmptyException").exceptionBuilderSupplier(StackSetNotEmptyException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChangeSetNotFound").exceptionBuilderSupplier(ChangeSetNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StackInstanceNotFoundException").exceptionBuilderSupplier(StackInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateTransition").exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationIdAlreadyExistsException").exceptionBuilderSupplier(OperationIdAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TypeNotFoundException").exceptionBuilderSupplier(TypeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreatedButModifiedException").exceptionBuilderSupplier(CreatedButModifiedException::builder).httpStatusCode(Integer.valueOf(409)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudFormationException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudFormationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.71").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFormationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

