/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;
import software.amazon.awssdk.services.cloudformation.model.StackEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackEventsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackEventsResponse> {
    private static final SdkField<List<StackEvent>> STACK_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeStackEventsResponse.getter(DescribeStackEventsResponse::stackEvents)).setter(DescribeStackEventsResponse.setter(Builder::stackEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStackEventsResponse.getter(DescribeStackEventsResponse::nextToken)).setter(DescribeStackEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StackEvent> stackEvents;
    private final String nextToken;

    private DescribeStackEventsResponse(BuilderImpl builder) {
        super(builder);
        this.stackEvents = builder.stackEvents;
        this.nextToken = builder.nextToken;
    }

    public List<StackEvent> stackEvents() {
        return this.stackEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackEventsResponse)) {
            return false;
        }
        DescribeStackEventsResponse other = (DescribeStackEventsResponse)((Object)obj);
        return Objects.equals(this.stackEvents(), other.stackEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStackEventsResponse").add("StackEvents", this.stackEvents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackEvents": {
                return Optional.ofNullable(clazz.cast(this.stackEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackEventsResponse, T> g) {
        return obj -> g.apply((DescribeStackEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackEvent> stackEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackEventsResponse model) {
            super(model);
            this.stackEvents(model.stackEvents);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackEvent.Builder> getStackEvents() {
            return this.stackEvents != null ? (Collection)this.stackEvents.stream().map(StackEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackEvents(Collection<StackEvent> stackEvents) {
            this.stackEvents = StackEventsCopier.copy(stackEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackEvents(StackEvent ... stackEvents) {
            this.stackEvents(Arrays.asList(stackEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackEvents(Consumer<StackEvent.Builder> ... stackEvents) {
            this.stackEvents(Stream.of(stackEvents).map(c -> (StackEvent)((StackEvent.Builder)StackEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStackEvents(Collection<StackEvent.BuilderImpl> stackEvents) {
            this.stackEvents = StackEventsCopier.copyFromBuilder(stackEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStackEventsResponse build() {
            return new DescribeStackEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackEventsResponse> {
        public Builder stackEvents(Collection<StackEvent> var1);

        public Builder stackEvents(StackEvent ... var1);

        public Builder stackEvents(Consumer<StackEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

