/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, GetTemplateRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTemplateRequest.getter(GetTemplateRequest::stackName)).setter(GetTemplateRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTemplateRequest.getter(GetTemplateRequest::changeSetName)).setter(GetTemplateRequest.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> TEMPLATE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTemplateRequest.getter(GetTemplateRequest::templateStageAsString)).setter(GetTemplateRequest.setter(Builder::templateStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateStage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, CHANGE_SET_NAME_FIELD, TEMPLATE_STAGE_FIELD));
    private final String stackName;
    private final String changeSetName;
    private final String templateStage;

    private GetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.changeSetName = builder.changeSetName;
        this.templateStage = builder.templateStage;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public TemplateStage templateStage() {
        return TemplateStage.fromValue(this.templateStage);
    }

    public String templateStageAsString() {
        return this.templateStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateStageAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateRequest)) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.templateStageAsString(), other.templateStageAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetTemplateRequest").add("StackName", (Object)this.stackName()).add("ChangeSetName", (Object)this.changeSetName()).add("TemplateStage", (Object)this.templateStageAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "TemplateStage": {
                return Optional.ofNullable(clazz.cast(this.templateStageAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateRequest, T> g) {
        return obj -> g.apply((GetTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String changeSetName;
        private String templateStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.changeSetName(model.changeSetName);
            this.templateStage(model.templateStage);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getTemplateStage() {
            return this.templateStage;
        }

        @Override
        public final Builder templateStage(String templateStage) {
            this.templateStage = templateStage;
            return this;
        }

        @Override
        public final Builder templateStage(TemplateStage templateStage) {
            this.templateStage(templateStage.toString());
            return this;
        }

        public final void setTemplateStage(String templateStage) {
            this.templateStage = templateStage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateRequest> {
        public Builder stackName(String var1);

        public Builder changeSetName(String var1);

        public Builder templateStage(String var1);

        public Builder templateStage(TemplateStage var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

