/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;

public class ListStackResourcesIterable
implements SdkIterable<ListStackResourcesResponse> {
    private final CloudFormationClient client;
    private final ListStackResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackResourcesIterable(CloudFormationClient client, ListStackResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStackResourcesResponseFetcher();
    }

    public Iterator<ListStackResourcesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<StackResourceSummary> stackResourceSummaries() {
        Function<ListStackResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackResourceSummaries() != null) {
                return response.stackResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListStackResourcesIterable resume(ListStackResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStackResourcesIterable(this.client, (ListStackResourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListStackResourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStackResourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStackResourcesResponseFetcher
    implements SyncPageFetcher<ListStackResourcesResponse> {
        private ListStackResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListStackResourcesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListStackResourcesResponse nextPage(ListStackResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListStackResourcesIterable.this.client.listStackResources(ListStackResourcesIterable.this.firstRequest);
            }
            return ListStackResourcesIterable.this.client.listStackResources((ListStackResourcesRequest)((Object)ListStackResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

