/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;

public class DescribeStackSetRequestMarshaller
implements Marshaller<Request<DescribeStackSetRequest>, DescribeStackSetRequest> {
    public Request<DescribeStackSetRequest> marshall(DescribeStackSetRequest describeStackSetRequest) {
        if (describeStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeStackSetRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)describeStackSetRequest.stackSetName()));
        }
        return request;
    }
}

