/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;

public class DescribeStackSetOperationRequestMarshaller
implements Marshaller<Request<DescribeStackSetOperationRequest>, DescribeStackSetOperationRequest> {
    public Request<DescribeStackSetOperationRequest> marshall(DescribeStackSetOperationRequest describeStackSetOperationRequest) {
        if (describeStackSetOperationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeStackSetOperationRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackSetOperation");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackSetOperationRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)describeStackSetOperationRequest.stackSetName()));
        }
        if (describeStackSetOperationRequest.operationId() != null) {
            request.addParameter("OperationId", StringUtils.fromString((String)describeStackSetOperationRequest.operationId()));
        }
        return request;
    }
}

