/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;

public class ListStacksRequestMarshaller
implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {
    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {
        List<String> stackStatusFiltersList;
        if (listStacksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listStacksRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStacksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStacksRequest.nextToken()));
        }
        if ((stackStatusFiltersList = listStacksRequest.stackStatusFiltersStrings()) != null) {
            if (!stackStatusFiltersList.isEmpty()) {
                int stackStatusFiltersListIndex = 1;
                for (String stackStatusFiltersListValue : stackStatusFiltersList) {
                    if (stackStatusFiltersListValue != null) {
                        request.addParameter("StackStatusFilter.member." + stackStatusFiltersListIndex, StringUtils.fromString((String)stackStatusFiltersListValue));
                    }
                    ++stackStatusFiltersListIndex;
                }
            } else {
                request.addParameter("StackStatusFilter", "");
            }
        }
        return request;
    }
}

