/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateStackRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private final String stackName;
    private final String templateBody;
    private final String templateURL;
    private final Boolean usePreviousTemplate;
    private final String stackPolicyDuringUpdateBody;
    private final String stackPolicyDuringUpdateURL;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<String> resourceTypes;
    private final String roleARN;
    private final RollbackConfiguration rollbackConfiguration;
    private final String stackPolicyBody;
    private final String stackPolicyURL;
    private final List<String> notificationARNs;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.stackPolicyDuringUpdateBody = builder.stackPolicyDuringUpdateBody;
        this.stackPolicyDuringUpdateURL = builder.stackPolicyDuringUpdateURL;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public Boolean usePreviousTemplate() {
        return this.usePreviousTemplate;
    }

    public String stackPolicyDuringUpdateBody() {
        return this.stackPolicyDuringUpdateBody;
    }

    public String stackPolicyDuringUpdateURL() {
        return this.stackPolicyDuringUpdateURL;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public RollbackConfiguration rollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public String stackPolicyBody() {
        return this.stackPolicyBody;
    }

    public String stackPolicyURL() {
        return this.stackPolicyURL;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyDuringUpdateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyDuringUpdateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.usePreviousTemplate(), other.usePreviousTemplate()) && Objects.equals(this.stackPolicyDuringUpdateBody(), other.stackPolicyDuringUpdateBody()) && Objects.equals(this.stackPolicyDuringUpdateURL(), other.stackPolicyDuringUpdateURL()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.capabilitiesStrings(), other.capabilitiesStrings()) && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.rollbackConfiguration(), other.rollbackConfiguration()) && Objects.equals(this.stackPolicyBody(), other.stackPolicyBody()) && Objects.equals(this.stackPolicyURL(), other.stackPolicyURL()) && Objects.equals(this.notificationARNs(), other.notificationARNs()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.templateBody() != null) {
            sb.append("TemplateBody: ").append(this.templateBody()).append(",");
        }
        if (this.templateURL() != null) {
            sb.append("TemplateURL: ").append(this.templateURL()).append(",");
        }
        if (this.usePreviousTemplate() != null) {
            sb.append("UsePreviousTemplate: ").append(this.usePreviousTemplate()).append(",");
        }
        if (this.stackPolicyDuringUpdateBody() != null) {
            sb.append("StackPolicyDuringUpdateBody: ").append(this.stackPolicyDuringUpdateBody()).append(",");
        }
        if (this.stackPolicyDuringUpdateURL() != null) {
            sb.append("StackPolicyDuringUpdateURL: ").append(this.stackPolicyDuringUpdateURL()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(this.capabilitiesStrings()).append(",");
        }
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.rollbackConfiguration() != null) {
            sb.append("RollbackConfiguration: ").append(this.rollbackConfiguration()).append(",");
        }
        if (this.stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(this.stackPolicyBody()).append(",");
        }
        if (this.stackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(this.stackPolicyURL()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "TemplateBody": {
                return Optional.of(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.of(clazz.cast(this.templateURL()));
            }
            case "UsePreviousTemplate": {
                return Optional.of(clazz.cast(this.usePreviousTemplate()));
            }
            case "StackPolicyDuringUpdateBody": {
                return Optional.of(clazz.cast(this.stackPolicyDuringUpdateBody()));
            }
            case "StackPolicyDuringUpdateURL": {
                return Optional.of(clazz.cast(this.stackPolicyDuringUpdateURL()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "ResourceTypes": {
                return Optional.of(clazz.cast(this.resourceTypes()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "RollbackConfiguration": {
                return Optional.of(clazz.cast(this.rollbackConfiguration()));
            }
            case "StackPolicyBody": {
                return Optional.of(clazz.cast(this.stackPolicyBody()));
            }
            case "StackPolicyURL": {
                return Optional.of(clazz.cast(this.stackPolicyURL()));
            }
            case "NotificationARNs": {
                return Optional.of(clazz.cast(this.notificationARNs()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String templateBody;
        private String templateURL;
        private Boolean usePreviousTemplate;
        private String stackPolicyDuringUpdateBody;
        private String stackPolicyDuringUpdateURL;
        private List<Parameter> parameters;
        private List<String> capabilities;
        private List<String> resourceTypes;
        private String roleARN;
        private RollbackConfiguration rollbackConfiguration;
        private String stackPolicyBody;
        private String stackPolicyURL;
        private List<String> notificationARNs;
        private List<Tag> tags;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            this.stackName(model.stackName);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.usePreviousTemplate(model.usePreviousTemplate);
            this.stackPolicyDuringUpdateBody(model.stackPolicyDuringUpdateBody);
            this.stackPolicyDuringUpdateURL(model.stackPolicyDuringUpdateURL);
            this.parameters(model.parameters);
            this.capabilities(model.capabilities);
            this.resourceTypes(model.resourceTypes);
            this.roleARN(model.roleARN);
            this.rollbackConfiguration(model.rollbackConfiguration);
            this.stackPolicyBody(model.stackPolicyBody);
            this.stackPolicyURL(model.stackPolicyURL);
            this.notificationARNs(model.notificationARNs);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Boolean getUsePreviousTemplate() {
            return this.usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        public final String getStackPolicyDuringUpdateBody() {
            return this.stackPolicyDuringUpdateBody;
        }

        @Override
        public final Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
            return this;
        }

        public final void setStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
        }

        public final String getStackPolicyDuringUpdateURL() {
            return this.stackPolicyDuringUpdateURL;
        }

        @Override
        public final Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
            return this;
        }

        public final void setStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return this.rollbackConfiguration != null ? this.rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final String getStackPolicyBody() {
            return this.stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return this.stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder stackName(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder usePreviousTemplate(Boolean var1);

        public Builder stackPolicyDuringUpdateBody(String var1);

        public Builder stackPolicyDuringUpdateURL(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder roleARN(String var1);

        public Builder rollbackConfiguration(RollbackConfiguration var1);

        default public Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return this.rollbackConfiguration((RollbackConfiguration)((RollbackConfiguration.Builder)RollbackConfiguration.builder().apply(rollbackConfiguration)).build());
        }

        public Builder stackPolicyBody(String var1);

        public Builder stackPolicyURL(String var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder clientRequestToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

