/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Parameter
implements ToCopyableBuilder<Builder, Parameter> {
    private final String parameterKey;
    private final String parameterValue;
    private final Boolean usePreviousValue;

    private Parameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
        this.usePreviousValue = builder.usePreviousValue;
    }

    public String parameterKey() {
        return this.parameterKey;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public Boolean usePreviousValue() {
        return this.usePreviousValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePreviousValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.parameterKey(), other.parameterKey()) && Objects.equals(this.parameterValue(), other.parameterValue()) && Objects.equals(this.usePreviousValue(), other.usePreviousValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterKey() != null) {
            sb.append("ParameterKey: ").append(this.parameterKey()).append(",");
        }
        if (this.parameterValue() != null) {
            sb.append("ParameterValue: ").append(this.parameterValue()).append(",");
        }
        if (this.usePreviousValue() != null) {
            sb.append("UsePreviousValue: ").append(this.usePreviousValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterKey": {
                return Optional.of(clazz.cast(this.parameterKey()));
            }
            case "ParameterValue": {
                return Optional.of(clazz.cast(this.parameterValue()));
            }
            case "UsePreviousValue": {
                return Optional.of(clazz.cast(this.usePreviousValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String parameterValue;
        private Boolean usePreviousValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterKey(model.parameterKey);
            this.parameterValue(model.parameterValue);
            this.usePreviousValue(model.usePreviousValue);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Boolean getUsePreviousValue() {
            return this.usePreviousValue;
        }

        @Override
        public final Builder usePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
            return this;
        }

        public final void setUsePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Parameter> {
        public Builder parameterKey(String var1);

        public Builder parameterValue(String var1);

        public Builder usePreviousValue(Boolean var1);
    }
}

