/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStackSetOperationsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackSetOperationsResponse> {
    private final List<StackSetOperationSummary> summaries;
    private final String nextToken;

    private ListStackSetOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackSetOperationSummary> summaries() {
        return this.summaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationsResponse)) {
            return false;
        }
        ListStackSetOperationsResponse other = (ListStackSetOperationsResponse)((Object)obj);
        return Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.summaries() != null) {
            sb.append("Summaries: ").append(this.summaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summaries": {
                return Optional.of(clazz.cast(this.summaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackSetOperationSummary> summaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationsResponse model) {
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackSetOperationSummary.Builder> getSummaries() {
            return this.summaries != null ? (Collection)this.summaries.stream().map(StackSetOperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetOperationSummary> summaries) {
            this.summaries = StackSetOperationSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetOperationSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<StackSetOperationSummary.BuilderImpl> summaries) {
            this.summaries = StackSetOperationSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackSetOperationsResponse build() {
            return new ListStackSetOperationsResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, ListStackSetOperationsResponse> {
        public Builder summaries(Collection<StackSetOperationSummary> var1);

        public Builder summaries(StackSetOperationSummary ... var1);

        public Builder nextToken(String var1);
    }
}

