/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResource;
import software.amazon.awssdk.services.cloudformation.model.StackResourcesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackResourcesResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackResourcesResponse> {
    private final List<StackResource> stackResources;

    private DescribeStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResources = builder.stackResources;
    }

    public List<StackResource> stackResources() {
        return this.stackResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackResources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesResponse)) {
            return false;
        }
        DescribeStackResourcesResponse other = (DescribeStackResourcesResponse)((Object)obj);
        return Objects.equals(this.stackResources(), other.stackResources());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackResources() != null) {
            sb.append("StackResources: ").append(this.stackResources()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResources": {
                return Optional.of(clazz.cast(this.stackResources()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackResource> stackResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesResponse model) {
            this.stackResources(model.stackResources);
        }

        public final Collection<StackResource.Builder> getStackResources() {
            return this.stackResources != null ? (Collection)this.stackResources.stream().map(StackResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackResources(Collection<StackResource> stackResources) {
            this.stackResources = StackResourcesCopier.copy(stackResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(StackResource ... stackResources) {
            this.stackResources(Arrays.asList(stackResources));
            return this;
        }

        public final void setStackResources(Collection<StackResource.BuilderImpl> stackResources) {
            this.stackResources = StackResourcesCopier.copyFromBuilder(stackResources);
        }

        @Override
        public DescribeStackResourcesResponse build() {
            return new DescribeStackResourcesResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, DescribeStackResourcesResponse> {
        public Builder stackResources(Collection<StackResource> var1);

        public Builder stackResources(StackResource ... var1);
    }
}

