/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackInstanceRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, DescribeStackInstanceRequest> {
    private final String stackSetName;
    private final String stackInstanceAccount;
    private final String stackInstanceRegion;

    private DescribeStackInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.stackInstanceAccount = builder.stackInstanceAccount;
        this.stackInstanceRegion = builder.stackInstanceRegion;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public String stackInstanceAccount() {
        return this.stackInstanceAccount;
    }

    public String stackInstanceRegion() {
        return this.stackInstanceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackInstanceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackInstanceRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackInstanceRequest)) {
            return false;
        }
        DescribeStackInstanceRequest other = (DescribeStackInstanceRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.stackInstanceAccount(), other.stackInstanceAccount()) && Objects.equals(this.stackInstanceRegion(), other.stackInstanceRegion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackSetName() != null) {
            sb.append("StackSetName: ").append(this.stackSetName()).append(",");
        }
        if (this.stackInstanceAccount() != null) {
            sb.append("StackInstanceAccount: ").append(this.stackInstanceAccount()).append(",");
        }
        if (this.stackInstanceRegion() != null) {
            sb.append("StackInstanceRegion: ").append(this.stackInstanceRegion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.of(clazz.cast(this.stackSetName()));
            }
            case "StackInstanceAccount": {
                return Optional.of(clazz.cast(this.stackInstanceAccount()));
            }
            case "StackInstanceRegion": {
                return Optional.of(clazz.cast(this.stackInstanceRegion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackSetName;
        private String stackInstanceAccount;
        private String stackInstanceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackInstanceRequest model) {
            this.stackSetName(model.stackSetName);
            this.stackInstanceAccount(model.stackInstanceAccount);
            this.stackInstanceRegion(model.stackInstanceRegion);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getStackInstanceAccount() {
            return this.stackInstanceAccount;
        }

        @Override
        public final Builder stackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
            return this;
        }

        public final void setStackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
        }

        public final String getStackInstanceRegion() {
            return this.stackInstanceRegion;
        }

        @Override
        public final Builder stackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
            return this;
        }

        public final void setStackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeStackInstanceRequest build() {
            return new DescribeStackInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, DescribeStackInstanceRequest> {
        public Builder stackSetName(String var1);

        public Builder stackInstanceAccount(String var1);

        public Builder stackInstanceRegion(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

