/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TemplateParameter
implements ToCopyableBuilder<Builder, TemplateParameter> {
    private final String parameterKey;
    private final String defaultValue;
    private final Boolean noEcho;
    private final String description;

    private TemplateParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
    }

    public String parameterKey() {
        return this.parameterKey;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Boolean noEcho() {
        return this.noEcho;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameter)) {
            return false;
        }
        TemplateParameter other = (TemplateParameter)obj;
        return Objects.equals(this.parameterKey(), other.parameterKey()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.noEcho(), other.noEcho()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterKey() != null) {
            sb.append("ParameterKey: ").append(this.parameterKey()).append(",");
        }
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.noEcho() != null) {
            sb.append("NoEcho: ").append(this.noEcho()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterKey": {
                return Optional.of(clazz.cast(this.parameterKey()));
            }
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "NoEcho": {
                return Optional.of(clazz.cast(this.noEcho()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String defaultValue;
        private Boolean noEcho;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameter model) {
            this.parameterKey(model.parameterKey);
            this.defaultValue(model.defaultValue);
            this.noEcho(model.noEcho);
            this.description(model.description);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final Boolean getNoEcho() {
            return this.noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public TemplateParameter build() {
            return new TemplateParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TemplateParameter> {
        public Builder parameterKey(String var1);

        public Builder defaultValue(String var1);

        public Builder noEcho(Boolean var1);

        public Builder description(String var1);
    }
}

