/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Export
implements ToCopyableBuilder<Builder, Export> {
    private final String exportingStackId;
    private final String name;
    private final String value;

    private Export(BuilderImpl builder) {
        this.exportingStackId = builder.exportingStackId;
        this.name = builder.name;
        this.value = builder.value;
    }

    public String exportingStackId() {
        return this.exportingStackId;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportingStackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export)obj;
        return Objects.equals(this.exportingStackId(), other.exportingStackId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.exportingStackId() != null) {
            sb.append("ExportingStackId: ").append(this.exportingStackId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportingStackId": {
                return Optional.of(clazz.cast(this.exportingStackId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String exportingStackId;
        private String name;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Export model) {
            this.exportingStackId(model.exportingStackId);
            this.name(model.name);
            this.value(model.value);
        }

        public final String getExportingStackId() {
            return this.exportingStackId;
        }

        @Override
        public final Builder exportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
            return this;
        }

        public final void setExportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public Export build() {
            return new Export(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Export> {
        public Builder exportingStackId(String var1);

        public Builder name(String var1);

        public Builder value(String var1);
    }
}

