/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudformation.model.AccountListCopier;
import software.amazon.awssdk.services.cloudformation.model.RegionListCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteStackInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteStackInstancesRequest> {
    private final String stackSetName;
    private final List<String> accounts;
    private final List<String> regions;
    private final StackSetOperationPreferences operationPreferences;
    private final Boolean retainStacks;
    private final String operationId;

    private DeleteStackInstancesRequest(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.operationPreferences = builder.operationPreferences;
        this.retainStacks = builder.retainStacks;
        this.operationId = builder.operationId;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public List<String> accounts() {
        return this.accounts;
    }

    public List<String> regions() {
        return this.regions;
    }

    public StackSetOperationPreferences operationPreferences() {
        return this.operationPreferences;
    }

    public Boolean retainStacks() {
        return this.retainStacks;
    }

    public String operationId() {
        return this.operationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.regions());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainStacks());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStackInstancesRequest)) {
            return false;
        }
        DeleteStackInstancesRequest other = (DeleteStackInstancesRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.operationPreferences(), other.operationPreferences()) && Objects.equals(this.retainStacks(), other.retainStacks()) && Objects.equals(this.operationId(), other.operationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackSetName() != null) {
            sb.append("StackSetName: ").append(this.stackSetName()).append(",");
        }
        if (this.accounts() != null) {
            sb.append("Accounts: ").append(this.accounts()).append(",");
        }
        if (this.regions() != null) {
            sb.append("Regions: ").append(this.regions()).append(",");
        }
        if (this.operationPreferences() != null) {
            sb.append("OperationPreferences: ").append(this.operationPreferences()).append(",");
        }
        if (this.retainStacks() != null) {
            sb.append("RetainStacks: ").append(this.retainStacks()).append(",");
        }
        if (this.operationId() != null) {
            sb.append("OperationId: ").append(this.operationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.of(clazz.cast(this.stackSetName()));
            }
            case "Accounts": {
                return Optional.of(clazz.cast(this.accounts()));
            }
            case "Regions": {
                return Optional.of(clazz.cast(this.regions()));
            }
            case "OperationPreferences": {
                return Optional.of(clazz.cast(this.operationPreferences()));
            }
            case "RetainStacks": {
                return Optional.of(clazz.cast(this.retainStacks()));
            }
            case "OperationId": {
                return Optional.of(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private List<String> accounts;
        private List<String> regions;
        private StackSetOperationPreferences operationPreferences;
        private Boolean retainStacks;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStackInstancesRequest model) {
            this.stackSetName(model.stackSetName);
            this.accounts(model.accounts);
            this.regions(model.regions);
            this.operationPreferences(model.operationPreferences);
            this.retainStacks(model.retainStacks);
            this.operationId(model.operationId);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final Collection<String> getAccounts() {
            return this.accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return this.operationPreferences != null ? this.operationPreferences.toBuilder() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        public final Boolean getRetainStacks() {
            return this.retainStacks;
        }

        @Override
        public final Builder retainStacks(Boolean retainStacks) {
            this.retainStacks = retainStacks;
            return this;
        }

        public final void setRetainStacks(Boolean retainStacks) {
            this.retainStacks = retainStacks;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public DeleteStackInstancesRequest build() {
            return new DeleteStackInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteStackInstancesRequest> {
        public Builder stackSetName(String var1);

        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder operationPreferences(StackSetOperationPreferences var1);

        default public Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return this.operationPreferences((StackSetOperationPreferences)((StackSetOperationPreferences.Builder)StackSetOperationPreferences.builder().apply(operationPreferences)).build());
        }

        public Builder retainStacks(Boolean var1);

        public Builder operationId(String var1);
    }
}

