/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus;
import software.amazon.awssdk.services.cloudformation.model.ExecutionStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeSetSummary
implements ToCopyableBuilder<Builder, ChangeSetSummary> {
    private final String stackId;
    private final String stackName;
    private final String changeSetId;
    private final String changeSetName;
    private final String executionStatus;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final String description;

    private ChangeSetSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.changeSetName = builder.changeSetName;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public String executionStatusString() {
        return this.executionStatus;
    }

    public ChangeSetStatus status() {
        return ChangeSetStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetSummary)) {
            return false;
        }
        ChangeSetSummary other = (ChangeSetSummary)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.executionStatusString(), other.executionStatusString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.changeSetId() != null) {
            sb.append("ChangeSetId: ").append(this.changeSetId()).append(",");
        }
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.executionStatusString() != null) {
            sb.append("ExecutionStatus: ").append(this.executionStatusString()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "ChangeSetId": {
                return Optional.of(clazz.cast(this.changeSetId()));
            }
            case "ChangeSetName": {
                return Optional.of(clazz.cast(this.changeSetName()));
            }
            case "ExecutionStatus": {
                return Optional.of(clazz.cast(this.executionStatusString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String changeSetId;
        private String changeSetName;
        private String executionStatus;
        private String status;
        private String statusReason;
        private Instant creationTime;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetSummary model) {
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.changeSetId(model.changeSetId);
            this.changeSetName(model.changeSetName);
            this.executionStatus(model.executionStatus);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.creationTime(model.creationTime);
            this.description(model.description);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ChangeSetSummary build() {
            return new ChangeSetSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeSetSummary> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder changeSetId(String var1);

        public Builder changeSetName(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder status(String var1);

        public Builder status(ChangeSetStatus var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);
    }
}

