/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;

public class UpdateStackRequestMarshaller
implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {
        List<Tag> list;
        List<String> list2;
        List<String> resourceTypesList;
        List<String> capabilitiesList;
        List<Parameter> parametersList;
        if (updateStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)updateStackRequest.stackName()));
        }
        if (updateStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)updateStackRequest.templateBody()));
        }
        if (updateStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)updateStackRequest.templateURL()));
        }
        if (updateStackRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)updateStackRequest.usePreviousTemplate()));
        }
        if (updateStackRequest.stackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody", StringUtils.fromString((String)updateStackRequest.stackPolicyDuringUpdateBody()));
        }
        if (updateStackRequest.stackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL", StringUtils.fromString((String)updateStackRequest.stackPolicyDuringUpdateURL()));
        }
        if ((parametersList = updateStackRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if ((capabilitiesList = updateStackRequest.capabilitiesStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String string : capabilitiesList) {
                    if (string != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)string));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((resourceTypesList = updateStackRequest.resourceTypes()) != null) {
            if (!resourceTypesList.isEmpty()) {
                boolean bl = true;
                for (String string : resourceTypesList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("ResourceTypes.member." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }
        if (updateStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)updateStackRequest.roleARN()));
        }
        if (updateStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)updateStackRequest.stackPolicyBody()));
        }
        if (updateStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)updateStackRequest.stackPolicyURL()));
        }
        if ((list2 = updateStackRequest.notificationARNs()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (String notificationARNsListValue : list2) {
                    void var7_18;
                    if (notificationARNsListValue != null) {
                        request.addParameter("NotificationARNs.member." + (int)var7_18, StringUtils.fromString((String)notificationARNsListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }
        if ((list = updateStackRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var8_24;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var8_24;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (updateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)updateStackRequest.clientRequestToken()));
        }
        return request;
    }
}

