/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.ChangeAction;
import software.amazon.awssdk.services.cloudformation.model.Replacement;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetailsCopier;
import software.amazon.awssdk.services.cloudformation.model.ScopeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceChange
implements ToCopyableBuilder<Builder, ResourceChange> {
    private final String action;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final String replacement;
    private final List<String> scope;
    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Replacement replacement() {
        return Replacement.fromValue(this.replacement);
    }

    public String replacementString() {
        return this.replacement;
    }

    public List<ResourceAttribute> scope() {
        return TypeConverter.convert(this.scope, ResourceAttribute::fromValue);
    }

    public List<String> scopeStrings() {
        return this.scope;
    }

    public List<ResourceChangeDetail> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionString() == null ? 0 : this.actionString().hashCode());
        hashCode = 31 * hashCode + (this.logicalResourceId() == null ? 0 : this.logicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.physicalResourceId() == null ? 0 : this.physicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.replacementString() == null ? 0 : this.replacementString().hashCode());
        hashCode = 31 * hashCode + (this.scopeStrings() == null ? 0 : this.scopeStrings().hashCode());
        hashCode = 31 * hashCode + (this.details() == null ? 0 : this.details().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        if (other.actionString() == null ^ this.actionString() == null) {
            return false;
        }
        if (other.actionString() != null && !other.actionString().equals(this.actionString())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.replacementString() == null ^ this.replacementString() == null) {
            return false;
        }
        if (other.replacementString() != null && !other.replacementString().equals(this.replacementString())) {
            return false;
        }
        if (other.scopeStrings() == null ^ this.scopeStrings() == null) {
            return false;
        }
        if (other.scopeStrings() != null && !other.scopeStrings().equals(this.scopeStrings())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        return other.details() == null || other.details().equals(this.details());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.logicalResourceId()).append(",");
        }
        if (this.physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.physicalResourceId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.replacementString() != null) {
            sb.append("Replacement: ").append(this.replacementString()).append(",");
        }
        if (this.scopeStrings() != null) {
            sb.append("Scope: ").append(this.scopeStrings()).append(",");
        }
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "LogicalResourceId": {
                return Optional.of(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.of(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "Replacement": {
                return Optional.of(clazz.cast(this.replacementString()));
            }
            case "Scope": {
                return Optional.of(clazz.cast(this.scopeStrings()));
            }
            case "Details": {
                return Optional.of(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private String replacement;
        private List<String> scope;
        private List<ResourceChangeDetail> details;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            this.action(model.action);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.replacement(model.replacement);
            this.scope(model.scope);
            this.details(model.details);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getReplacement() {
            return this.replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement.toString());
            return this;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public final Collection<String> getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        public final Collection<ResourceChangeDetail.Builder> getDetails() {
            return this.details != null ? (Collection)this.details.stream().map(ResourceChangeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        public ResourceChange build() {
            return new ResourceChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceChange> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder replacement(String var1);

        public Builder replacement(Replacement var1);

        public Builder scope(Collection<String> var1);

        public Builder scope(String ... var1);

        public Builder details(Collection<ResourceChangeDetail> var1);

        public Builder details(ResourceChangeDetail ... var1);
    }
}

