/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.OnFailure;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateStackRequest> {
    private final String stackName;
    private final String templateBody;
    private final String templateURL;
    private final List<Parameter> parameters;
    private final Boolean disableRollback;
    private final Integer timeoutInMinutes;
    private final List<String> notificationARNs;
    private final List<String> capabilities;
    private final List<String> resourceTypes;
    private final String roleARN;
    private final String onFailure;
    private final String stackPolicyBody;
    private final String stackPolicyURL;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private CreateStackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
        this.disableRollback = builder.disableRollback;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.notificationARNs = builder.notificationARNs;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.onFailure = builder.onFailure;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Boolean disableRollback() {
        return this.disableRollback;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public OnFailure onFailure() {
        return OnFailure.fromValue(this.onFailure);
    }

    public String onFailureString() {
        return this.onFailure;
    }

    public String stackPolicyBody() {
        return this.stackPolicyBody;
    }

    public String stackPolicyURL() {
        return this.stackPolicyURL;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.templateBody() == null ? 0 : this.templateBody().hashCode());
        hashCode = 31 * hashCode + (this.templateURL() == null ? 0 : this.templateURL().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.disableRollback() == null ? 0 : this.disableRollback().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutes() == null ? 0 : this.timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.notificationARNs() == null ? 0 : this.notificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.capabilitiesStrings() == null ? 0 : this.capabilitiesStrings().hashCode());
        hashCode = 31 * hashCode + (this.resourceTypes() == null ? 0 : this.resourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.onFailureString() == null ? 0 : this.onFailureString().hashCode());
        hashCode = 31 * hashCode + (this.stackPolicyBody() == null ? 0 : this.stackPolicyBody().hashCode());
        hashCode = 31 * hashCode + (this.stackPolicyURL() == null ? 0 : this.stackPolicyURL().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.clientRequestToken() == null ? 0 : this.clientRequestToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.templateBody() == null ^ this.templateBody() == null) {
            return false;
        }
        if (other.templateBody() != null && !other.templateBody().equals(this.templateBody())) {
            return false;
        }
        if (other.templateURL() == null ^ this.templateURL() == null) {
            return false;
        }
        if (other.templateURL() != null && !other.templateURL().equals(this.templateURL())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.disableRollback() == null ^ this.disableRollback() == null) {
            return false;
        }
        if (other.disableRollback() != null && !other.disableRollback().equals(this.disableRollback())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.capabilitiesStrings() == null ^ this.capabilitiesStrings() == null) {
            return false;
        }
        if (other.capabilitiesStrings() != null && !other.capabilitiesStrings().equals(this.capabilitiesStrings())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.onFailureString() == null ^ this.onFailureString() == null) {
            return false;
        }
        if (other.onFailureString() != null && !other.onFailureString().equals(this.onFailureString())) {
            return false;
        }
        if (other.stackPolicyBody() == null ^ this.stackPolicyBody() == null) {
            return false;
        }
        if (other.stackPolicyBody() != null && !other.stackPolicyBody().equals(this.stackPolicyBody())) {
            return false;
        }
        if (other.stackPolicyURL() == null ^ this.stackPolicyURL() == null) {
            return false;
        }
        if (other.stackPolicyURL() != null && !other.stackPolicyURL().equals(this.stackPolicyURL())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        return other.clientRequestToken() == null || other.clientRequestToken().equals(this.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.templateBody() != null) {
            sb.append("TemplateBody: ").append(this.templateBody()).append(",");
        }
        if (this.templateURL() != null) {
            sb.append("TemplateURL: ").append(this.templateURL()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.disableRollback() != null) {
            sb.append("DisableRollback: ").append(this.disableRollback()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(this.capabilitiesStrings()).append(",");
        }
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.onFailureString() != null) {
            sb.append("OnFailure: ").append(this.onFailureString()).append(",");
        }
        if (this.stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(this.stackPolicyBody()).append(",");
        }
        if (this.stackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(this.stackPolicyURL()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "TemplateBody": {
                return Optional.of(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.of(clazz.cast(this.templateURL()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "DisableRollback": {
                return Optional.of(clazz.cast(this.disableRollback()));
            }
            case "TimeoutInMinutes": {
                return Optional.of(clazz.cast(this.timeoutInMinutes()));
            }
            case "NotificationARNs": {
                return Optional.of(clazz.cast(this.notificationARNs()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "ResourceTypes": {
                return Optional.of(clazz.cast(this.resourceTypes()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "OnFailure": {
                return Optional.of(clazz.cast(this.onFailureString()));
            }
            case "StackPolicyBody": {
                return Optional.of(clazz.cast(this.stackPolicyBody()));
            }
            case "StackPolicyURL": {
                return Optional.of(clazz.cast(this.stackPolicyURL()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String templateBody;
        private String templateURL;
        private List<Parameter> parameters;
        private Boolean disableRollback;
        private Integer timeoutInMinutes;
        private List<String> notificationARNs;
        private List<String> capabilities;
        private List<String> resourceTypes;
        private String roleARN;
        private String onFailure;
        private String stackPolicyBody;
        private String stackPolicyURL;
        private List<Tag> tags;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            this.stackName(model.stackName);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.parameters(model.parameters);
            this.disableRollback(model.disableRollback);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.notificationARNs(model.notificationARNs);
            this.capabilities(model.capabilities);
            this.resourceTypes(model.resourceTypes);
            this.roleARN(model.roleARN);
            this.onFailure(model.onFailure);
            this.stackPolicyBody(model.stackPolicyBody);
            this.stackPolicyURL(model.stackPolicyURL);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Boolean getDisableRollback() {
            return this.disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        @Override
        public final Builder onFailure(OnFailure onFailure) {
            this.onFailure(onFailure.toString());
            return this;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        public final String getStackPolicyBody() {
            return this.stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return this.stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateStackRequest> {
        public Builder stackName(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder disableRollback(Boolean var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder roleARN(String var1);

        public Builder onFailure(String var1);

        public Builder onFailure(OnFailure var1);

        public Builder stackPolicyBody(String var1);

        public Builder stackPolicyURL(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder clientRequestToken(String var1);
    }
}

