/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.ObjectMapperSingleton;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class ChangeSetCreateComplete {
    ChangeSetCreateComplete() {
    }

    static class IsValidationErrorMatcher
    extends WaiterAcceptor<DescribeChangeSetResponse> {
        IsValidationErrorMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ValidationError".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsFAILEDMatcher
    extends WaiterAcceptor<DescribeChangeSetResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsFAILEDMatcher() {
        }

        public boolean matches(DescribeChangeSetResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("status");
        }
    }

    static class IsCREATE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeChangeSetResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsCREATE_COMPLETEMatcher() {
        }

        public boolean matches(DescribeChangeSetResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("status");
        }
    }
}

