/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeStackResourceRequestMarshaller
implements Marshaller<Request<DescribeStackResourceRequest>, DescribeStackResourceRequest> {
    public Request<DescribeStackResourceRequest> marshall(DescribeStackResourceRequest describeStackResourceRequest) {
        if (describeStackResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStackResourceRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackResourceRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)describeStackResourceRequest.stackName()));
        }
        if (describeStackResourceRequest.logicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringUtils.fromString((String)describeStackResourceRequest.logicalResourceId()));
        }
        return request;
    }
}

