/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.ImportsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListImportsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListImportsResponse> {
    private final List<String> imports;
    private final String nextToken;

    private ListImportsResponse(BuilderImpl builder) {
        this.imports = builder.imports;
        this.nextToken = builder.nextToken;
    }

    public List<String> imports() {
        return this.imports;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imports() == null ? 0 : this.imports().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse)((Object)obj);
        if (other.imports() == null ^ this.imports() == null) {
            return false;
        }
        if (other.imports() != null && !other.imports().equals(this.imports())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imports() != null) {
            sb.append("Imports: ").append(this.imports()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> imports;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            this.setImports(model.imports);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getImports() {
            return this.imports;
        }

        @Override
        public final Builder imports(Collection<String> imports) {
            this.imports = ImportsCopier.copy(imports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(String ... imports) {
            this.imports(Arrays.asList(imports));
            return this;
        }

        public final void setImports(Collection<String> imports) {
            this.imports = ImportsCopier.copy(imports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListImportsResponse> {
        public Builder imports(Collection<String> var1);

        public Builder imports(String ... var1);

        public Builder nextToken(String var1);
    }
}

