/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetTemplateSummaryRequestMarshaller
implements Marshaller<Request<GetTemplateSummaryRequest>, GetTemplateSummaryRequest> {
    public Request<GetTemplateSummaryRequest> marshall(GetTemplateSummaryRequest getTemplateSummaryRequest) {
        if (getTemplateSummaryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTemplateSummaryRequest, "CloudFormationClient");
        request.addParameter("Action", "GetTemplateSummary");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTemplateSummaryRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)getTemplateSummaryRequest.templateBody()));
        }
        if (getTemplateSummaryRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)getTemplateSummaryRequest.templateURL()));
        }
        if (getTemplateSummaryRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)getTemplateSummaryRequest.stackName()));
        }
        return request;
    }
}

