/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetTemplateRequestMarshaller
implements Marshaller<Request<GetTemplateRequest>, GetTemplateRequest> {
    public Request<GetTemplateRequest> marshall(GetTemplateRequest getTemplateRequest) {
        if (getTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTemplateRequest, "CloudFormationClient");
        request.addParameter("Action", "GetTemplate");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTemplateRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)getTemplateRequest.stackName()));
        }
        if (getTemplateRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)getTemplateRequest.changeSetName()));
        }
        if (getTemplateRequest.templateStage() != null) {
            request.addParameter("TemplateStage", StringUtils.fromString((String)getTemplateRequest.templateStage()));
        }
        return request;
    }
}

