/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.TemplateParameter;
import software.amazon.awssdk.services.cloudformation.model.TemplateParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.TransformsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidateTemplateResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ValidateTemplateResponse> {
    private final List<TemplateParameter> parameters;
    private final String description;
    private final List<String> capabilities;
    private final String capabilitiesReason;
    private final List<String> declaredTransforms;

    private ValidateTemplateResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.declaredTransforms = builder.declaredTransforms;
    }

    public List<TemplateParameter> parameters() {
        return this.parameters;
    }

    public String description() {
        return this.description;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public String capabilitiesReason() {
        return this.capabilitiesReason;
    }

    public List<String> declaredTransforms() {
        return this.declaredTransforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.capabilities() == null ? 0 : this.capabilities().hashCode());
        hashCode = 31 * hashCode + (this.capabilitiesReason() == null ? 0 : this.capabilitiesReason().hashCode());
        hashCode = 31 * hashCode + (this.declaredTransforms() == null ? 0 : this.declaredTransforms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateResponse)) {
            return false;
        }
        ValidateTemplateResponse other = (ValidateTemplateResponse)((Object)obj);
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.capabilitiesReason() == null ^ this.capabilitiesReason() == null) {
            return false;
        }
        if (other.capabilitiesReason() != null && !other.capabilitiesReason().equals(this.capabilitiesReason())) {
            return false;
        }
        if (other.declaredTransforms() == null ^ this.declaredTransforms() == null) {
            return false;
        }
        return other.declaredTransforms() == null || other.declaredTransforms().equals(this.declaredTransforms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.capabilities() != null) {
            sb.append("Capabilities: ").append(this.capabilities()).append(",");
        }
        if (this.capabilitiesReason() != null) {
            sb.append("CapabilitiesReason: ").append(this.capabilitiesReason()).append(",");
        }
        if (this.declaredTransforms() != null) {
            sb.append("DeclaredTransforms: ").append(this.declaredTransforms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TemplateParameter> parameters;
        private String description;
        private List<String> capabilities;
        private String capabilitiesReason;
        private List<String> declaredTransforms;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTemplateResponse model) {
            this.setParameters(model.parameters);
            this.setDescription(model.description);
            this.setCapabilities(model.capabilities);
            this.setCapabilitiesReason(model.capabilitiesReason);
            this.setDeclaredTransforms(model.declaredTransforms);
        }

        public final Collection<TemplateParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<TemplateParameter> parameters) {
            this.parameters = TemplateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TemplateParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<TemplateParameter> parameters) {
            this.parameters = TemplateParametersCopier.copy(parameters);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final String getCapabilitiesReason() {
            return this.capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getDeclaredTransforms() {
            return this.declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        public ValidateTemplateResponse build() {
            return new ValidateTemplateResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidateTemplateResponse> {
        public Builder parameters(Collection<TemplateParameter> var1);

        public Builder parameters(TemplateParameter ... var1);

        public Builder description(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilities(Capability ... var1);

        public Builder capabilitiesReason(String var1);

        public Builder declaredTransforms(Collection<String> var1);

        public Builder declaredTransforms(String ... var1);
    }
}

