/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListChangeSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListChangeSetsResponse> {
    private final List<ChangeSetSummary> summaries;
    private final String nextToken;

    private ListChangeSetsResponse(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public List<ChangeSetSummary> summaries() {
        return this.summaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.summaries() == null ? 0 : this.summaries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangeSetsResponse)) {
            return false;
        }
        ListChangeSetsResponse other = (ListChangeSetsResponse)((Object)obj);
        if (other.summaries() == null ^ this.summaries() == null) {
            return false;
        }
        if (other.summaries() != null && !other.summaries().equals(this.summaries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.summaries() != null) {
            sb.append("Summaries: ").append(this.summaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ChangeSetSummary> summaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangeSetsResponse model) {
            this.setSummaries(model.summaries);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ChangeSetSummary> getSummaries() {
            return this.summaries;
        }

        @Override
        public final Builder summaries(Collection<ChangeSetSummary> summaries) {
            this.summaries = ChangeSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(ChangeSetSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<ChangeSetSummary> summaries) {
            this.summaries = ChangeSetSummariesCopier.copy(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListChangeSetsResponse build() {
            return new ListChangeSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListChangeSetsResponse> {
        public Builder summaries(Collection<ChangeSetSummary> var1);

        public Builder summaries(ChangeSetSummary ... var1);

        public Builder nextToken(String var1);
    }
}

