/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetTemplateRequest> {
    private final String stackName;
    private final String changeSetName;
    private final String templateStage;

    private GetTemplateRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.changeSetName = builder.changeSetName;
        this.templateStage = builder.templateStage;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String templateStage() {
        return this.templateStage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.changeSetName() == null ? 0 : this.changeSetName().hashCode());
        hashCode = 31 * hashCode + (this.templateStage() == null ? 0 : this.templateStage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateRequest)) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.templateStage() == null ^ this.templateStage() == null) {
            return false;
        }
        return other.templateStage() == null || other.templateStage().equals(this.templateStage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.templateStage() != null) {
            sb.append("TemplateStage: ").append(this.templateStage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String changeSetName;
        private String templateStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateRequest model) {
            this.setStackName(model.stackName);
            this.setChangeSetName(model.changeSetName);
            this.setTemplateStage(model.templateStage);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getTemplateStage() {
            return this.templateStage;
        }

        @Override
        public final Builder templateStage(String templateStage) {
            this.templateStage = templateStage;
            return this;
        }

        @Override
        public final Builder templateStage(TemplateStage templateStage) {
            this.templateStage(templateStage.toString());
            return this;
        }

        public final void setTemplateStage(String templateStage) {
            this.templateStage = templateStage;
        }

        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTemplateRequest> {
        public Builder stackName(String var1);

        public Builder changeSetName(String var1);

        public Builder templateStage(String var1);

        public Builder templateStage(TemplateStage var1);
    }
}

