/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StacksCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStacksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;
    private final String nextToken;

    private DescribeStacksResponse(BuilderImpl builder) {
        this.stacks = builder.stacks;
        this.nextToken = builder.nextToken;
    }

    public List<Stack> stacks() {
        return this.stacks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stacks() == null ? 0 : this.stacks().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse)((Object)obj);
        if (other.stacks() == null ^ this.stacks() == null) {
            return false;
        }
        if (other.stacks() != null && !other.stacks().equals(this.stacks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stacks() != null) {
            sb.append("Stacks: ").append(this.stacks()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Stack> stacks;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            this.setStacks(model.stacks);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Stack> getStacks() {
            return this.stacks;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack ... stacks) {
            this.stacks(Arrays.asList(stacks));
            return this;
        }

        public final void setStacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStacksResponse> {
        public Builder stacks(Collection<Stack> var1);

        public Builder stacks(Stack ... var1);

        public Builder nextToken(String var1);
    }
}

