/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudformation.model.ResourcesToSkipCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContinueUpdateRollbackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ContinueUpdateRollbackRequest> {
    private final String stackName;
    private final String roleARN;
    private final List<String> resourcesToSkip;
    private final String clientRequestToken;

    private ContinueUpdateRollbackRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.roleARN = builder.roleARN;
        this.resourcesToSkip = builder.resourcesToSkip;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public List<String> resourcesToSkip() {
        return this.resourcesToSkip;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.resourcesToSkip() == null ? 0 : this.resourcesToSkip().hashCode());
        hashCode = 31 * hashCode + (this.clientRequestToken() == null ? 0 : this.clientRequestToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueUpdateRollbackRequest)) {
            return false;
        }
        ContinueUpdateRollbackRequest other = (ContinueUpdateRollbackRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.resourcesToSkip() == null ^ this.resourcesToSkip() == null) {
            return false;
        }
        if (other.resourcesToSkip() != null && !other.resourcesToSkip().equals(this.resourcesToSkip())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        return other.clientRequestToken() == null || other.clientRequestToken().equals(this.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.resourcesToSkip() != null) {
            sb.append("ResourcesToSkip: ").append(this.resourcesToSkip()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String roleARN;
        private List<String> resourcesToSkip;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueUpdateRollbackRequest model) {
            this.setStackName(model.stackName);
            this.setRoleARN(model.roleARN);
            this.setResourcesToSkip(model.resourcesToSkip);
            this.setClientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<String> getResourcesToSkip() {
            return this.resourcesToSkip;
        }

        @Override
        public final Builder resourcesToSkip(Collection<String> resourcesToSkip) {
            this.resourcesToSkip = ResourcesToSkipCopier.copy(resourcesToSkip);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToSkip(String ... resourcesToSkip) {
            this.resourcesToSkip(Arrays.asList(resourcesToSkip));
            return this;
        }

        public final void setResourcesToSkip(Collection<String> resourcesToSkip) {
            this.resourcesToSkip = ResourcesToSkipCopier.copy(resourcesToSkip);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public ContinueUpdateRollbackRequest build() {
            return new ContinueUpdateRollbackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContinueUpdateRollbackRequest> {
        public Builder stackName(String var1);

        public Builder roleARN(String var1);

        public Builder resourcesToSkip(Collection<String> var1);

        public Builder resourcesToSkip(String ... var1);

        public Builder clientRequestToken(String var1);
    }
}

