/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.ResourceChange;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail;
import software.amazon.awssdk.services.cloudformation.transform.ResourceChangeDetailUnmarshaller;

public class ResourceChangeUnmarshaller
implements Unmarshaller<ResourceChange, StaxUnmarshallerContext> {
    private static ResourceChangeUnmarshaller INSTANCE;

    public ResourceChange unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceChange.Builder resourceChange;
        block12: {
            resourceChange = ResourceChange.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> scope = null;
            ArrayList<ResourceChangeDetail> details = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    resourceChange.scope(scope);
                    resourceChange.details(details);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Action", targetDepth)) {
                        resourceChange.action(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LogicalResourceId", targetDepth)) {
                        resourceChange.logicalResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PhysicalResourceId", targetDepth)) {
                        resourceChange.physicalResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ResourceType", targetDepth)) {
                        resourceChange.resourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Replacement", targetDepth)) {
                        resourceChange.replacement(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Scope", targetDepth)) {
                        scope = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Scope/member", targetDepth)) {
                        scope.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Details", targetDepth)) {
                        details = new ArrayList<ResourceChangeDetail>();
                        continue;
                    }
                    if (!context.testExpression("Details/member", targetDepth)) continue;
                    details.add(ResourceChangeDetailUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            resourceChange.scope(scope);
            resourceChange.details(details);
        }
        return (ResourceChange)resourceChange.build();
    }

    public static ResourceChangeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceChangeUnmarshaller();
        }
        return INSTANCE;
    }
}

