/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListStacksRequestMarshaller
implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {
    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {
        List<String> stackStatusFiltersList;
        if (listStacksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStacksRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStacksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStacksRequest.nextToken()));
        }
        if ((stackStatusFiltersList = listStacksRequest.stackStatusFilters()) != null) {
            if (!stackStatusFiltersList.isEmpty()) {
                int stackStatusFiltersListIndex = 1;
                for (String stackStatusFiltersListValue : stackStatusFiltersList) {
                    if (stackStatusFiltersListValue != null) {
                        request.addParameter("StackStatusFilter.member." + stackStatusFiltersListIndex, StringUtils.fromString((String)stackStatusFiltersListValue));
                    }
                    ++stackStatusFiltersListIndex;
                }
            } else {
                request.addParameter("StackStatusFilter", "");
            }
        }
        return request;
    }
}

