/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SignalResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SignalResourceRequest> {
    private final String stackName;
    private final String logicalResourceId;
    private final String uniqueId;
    private final String status;

    private SignalResourceRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.uniqueId = builder.uniqueId;
        this.status = builder.status;
    }

    public String stackName() {
        return this.stackName;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.logicalResourceId() == null ? 0 : this.logicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.uniqueId() == null ? 0 : this.uniqueId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalResourceRequest)) {
            return false;
        }
        SignalResourceRequest other = (SignalResourceRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.uniqueId() == null ^ this.uniqueId() == null) {
            return false;
        }
        if (other.uniqueId() != null && !other.uniqueId().equals(this.uniqueId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.logicalResourceId()).append(",");
        }
        if (this.uniqueId() != null) {
            sb.append("UniqueId: ").append(this.uniqueId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String logicalResourceId;
        private String uniqueId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalResourceRequest model) {
            this.setStackName(model.stackName);
            this.setLogicalResourceId(model.logicalResourceId);
            this.setUniqueId(model.uniqueId);
            this.setStatus(model.status);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getUniqueId() {
            return this.uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSignalStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ResourceSignalStatus status) {
            this.status(status.toString());
        }

        public SignalResourceRequest build() {
            return new SignalResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SignalResourceRequest> {
        public Builder stackName(String var1);

        public Builder logicalResourceId(String var1);

        public Builder uniqueId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceSignalStatus var1);
    }
}

