/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;

public class UpdateStackRequestMarshaller
implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {
    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {
        RollbackConfiguration rollbackConfiguration;
        if (updateStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)updateStackRequest.stackName()));
        }
        if (updateStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)updateStackRequest.templateBody()));
        }
        if (updateStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)updateStackRequest.templateURL()));
        }
        if (updateStackRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringConversion.fromBoolean((Boolean)updateStackRequest.usePreviousTemplate()));
        }
        if (updateStackRequest.stackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody", StringConversion.fromString((String)updateStackRequest.stackPolicyDuringUpdateBody()));
        }
        if (updateStackRequest.stackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL", StringConversion.fromString((String)updateStackRequest.stackPolicyDuringUpdateURL()));
        }
        if (updateStackRequest.parameters().isEmpty() && !(updateStackRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!updateStackRequest.parameters().isEmpty() && !(updateStackRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = updateStackRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringConversion.fromString((String)parametersListValue.parameterKey()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                }
                if (parametersListValue.resolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringConversion.fromString((String)parametersListValue.resolvedValue()));
                }
                ++parametersListIndex;
            }
        }
        if (updateStackRequest.capabilitiesAsStrings().isEmpty() && !(updateStackRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!updateStackRequest.capabilitiesAsStrings().isEmpty() && !(updateStackRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> capabilitiesList = updateStackRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringConversion.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (updateStackRequest.resourceTypes().isEmpty() && !(updateStackRequest.resourceTypes() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceTypes", "");
        } else if (!updateStackRequest.resourceTypes().isEmpty() && !(updateStackRequest.resourceTypes() instanceof SdkAutoConstructList)) {
            List<String> resourceTypesList = updateStackRequest.resourceTypes();
            int resourceTypesListIndex = 1;
            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringConversion.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (updateStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString((String)updateStackRequest.roleARN()));
        }
        if ((rollbackConfiguration = updateStackRequest.rollbackConfiguration()) != null) {
            if (rollbackConfiguration.rollbackTriggers().isEmpty() && !(rollbackConfiguration.rollbackTriggers() instanceof SdkAutoConstructList)) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            } else if (!rollbackConfiguration.rollbackTriggers().isEmpty() && !(rollbackConfiguration.rollbackTriggers() instanceof SdkAutoConstructList)) {
                List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
                int rollbackTriggersListIndex = 1;
                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {
                    if (rollbackTriggersListValue.arn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringConversion.fromString((String)rollbackTriggersListValue.arn()));
                    }
                    if (rollbackTriggersListValue.type() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringConversion.fromString((String)rollbackTriggersListValue.type()));
                    }
                    ++rollbackTriggersListIndex;
                }
            }
            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringConversion.fromInteger((Integer)rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }
        if (updateStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringConversion.fromString((String)updateStackRequest.stackPolicyBody()));
        }
        if (updateStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringConversion.fromString((String)updateStackRequest.stackPolicyURL()));
        }
        if (updateStackRequest.notificationARNs().isEmpty() && !(updateStackRequest.notificationARNs() instanceof SdkAutoConstructList)) {
            request.addParameter("NotificationARNs", "");
        } else if (!updateStackRequest.notificationARNs().isEmpty() && !(updateStackRequest.notificationARNs() instanceof SdkAutoConstructList)) {
            List<String> notificationARNsList = updateStackRequest.notificationARNs();
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringConversion.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (updateStackRequest.tags().isEmpty() && !(updateStackRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!updateStackRequest.tags().isEmpty() && !(updateStackRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = updateStackRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (updateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString((String)updateStackRequest.clientRequestToken()));
        }
        return request;
    }
}

