/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;

public class UpdateStackInstancesRequestMarshaller
implements Marshaller<Request<UpdateStackInstancesRequest>, UpdateStackInstancesRequest> {
    public Request<UpdateStackInstancesRequest> marshall(UpdateStackInstancesRequest updateStackInstancesRequest) {
        if (updateStackInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)updateStackInstancesRequest.stackSetName()));
        }
        if (updateStackInstancesRequest.accounts().isEmpty() && !(updateStackInstancesRequest.accounts() instanceof SdkAutoConstructList)) {
            request.addParameter("Accounts", "");
        } else if (!updateStackInstancesRequest.accounts().isEmpty() && !(updateStackInstancesRequest.accounts() instanceof SdkAutoConstructList)) {
            List<String> accountsList = updateStackInstancesRequest.accounts();
            int accountsListIndex = 1;
            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringConversion.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if (updateStackInstancesRequest.regions().isEmpty() && !(updateStackInstancesRequest.regions() instanceof SdkAutoConstructList)) {
            request.addParameter("Regions", "");
        } else if (!updateStackInstancesRequest.regions().isEmpty() && !(updateStackInstancesRequest.regions() instanceof SdkAutoConstructList)) {
            List<String> regionsList = updateStackInstancesRequest.regions();
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringConversion.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        if (updateStackInstancesRequest.parameterOverrides().isEmpty() && !(updateStackInstancesRequest.parameterOverrides() instanceof SdkAutoConstructList)) {
            request.addParameter("ParameterOverrides", "");
        } else if (!updateStackInstancesRequest.parameterOverrides().isEmpty() && !(updateStackInstancesRequest.parameterOverrides() instanceof SdkAutoConstructList)) {
            List<Parameter> parameterOverridesList = updateStackInstancesRequest.parameterOverrides();
            int parameterOverridesListIndex = 1;
            for (Parameter parameterOverridesListValue : parameterOverridesList) {
                if (parameterOverridesListValue.parameterKey() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterKey", StringConversion.fromString((String)parameterOverridesListValue.parameterKey()));
                }
                if (parameterOverridesListValue.parameterValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterValue", StringConversion.fromString((String)parameterOverridesListValue.parameterValue()));
                }
                if (parameterOverridesListValue.usePreviousValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parameterOverridesListValue.usePreviousValue()));
                }
                if (parameterOverridesListValue.resolvedValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ResolvedValue", StringConversion.fromString((String)parameterOverridesListValue.resolvedValue()));
                }
                ++parameterOverridesListIndex;
            }
        }
        StackSetOperationPreferences operationPreferences = updateStackInstancesRequest.operationPreferences();
        if (operationPreferences != null) {
            if (operationPreferences.regionOrder().isEmpty() && !(operationPreferences.regionOrder() instanceof SdkAutoConstructList)) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            } else if (!operationPreferences.regionOrder().isEmpty() && !(operationPreferences.regionOrder() instanceof SdkAutoConstructList)) {
                List<String> regionOrderList = operationPreferences.regionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringConversion.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringConversion.fromInteger((Integer)operationPreferences.failureToleranceCount()));
            }
            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringConversion.fromInteger((Integer)operationPreferences.failureTolerancePercentage()));
            }
            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringConversion.fromInteger((Integer)operationPreferences.maxConcurrentCount()));
            }
            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringConversion.fromInteger((Integer)operationPreferences.maxConcurrentPercentage()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)updateStackInstancesRequest.operationId()));
        return request;
    }
}

