/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;

public class SignalResourceRequestMarshaller
implements Marshaller<Request<SignalResourceRequest>, SignalResourceRequest> {
    public Request<SignalResourceRequest> marshall(SignalResourceRequest signalResourceRequest) {
        if (signalResourceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)signalResourceRequest, "CloudFormationClient");
        request.addParameter("Action", "SignalResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (signalResourceRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)signalResourceRequest.stackName()));
        }
        if (signalResourceRequest.logicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringConversion.fromString((String)signalResourceRequest.logicalResourceId()));
        }
        if (signalResourceRequest.uniqueId() != null) {
            request.addParameter("UniqueId", StringConversion.fromString((String)signalResourceRequest.uniqueId()));
        }
        if (signalResourceRequest.statusAsString() != null) {
            request.addParameter("Status", StringConversion.fromString((String)signalResourceRequest.statusAsString()));
        }
        return request;
    }
}

