/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;

public class ListStackSetOperationResultsRequestMarshaller
implements Marshaller<Request<ListStackSetOperationResultsRequest>, ListStackSetOperationResultsRequest> {
    public Request<ListStackSetOperationResultsRequest> marshall(ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        if (listStackSetOperationResultsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listStackSetOperationResultsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackSetOperationResults");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackSetOperationResultsRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)listStackSetOperationResultsRequest.stackSetName()));
        }
        if (listStackSetOperationResultsRequest.operationId() != null) {
            request.addParameter("OperationId", StringConversion.fromString((String)listStackSetOperationResultsRequest.operationId()));
        }
        if (listStackSetOperationResultsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listStackSetOperationResultsRequest.nextToken()));
        }
        if (listStackSetOperationResultsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)listStackSetOperationResultsRequest.maxResults()));
        }
        return request;
    }
}

