/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;

public class GetTemplateSummaryRequestMarshaller
implements Marshaller<Request<GetTemplateSummaryRequest>, GetTemplateSummaryRequest> {
    public Request<GetTemplateSummaryRequest> marshall(GetTemplateSummaryRequest getTemplateSummaryRequest) {
        if (getTemplateSummaryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getTemplateSummaryRequest, "CloudFormationClient");
        request.addParameter("Action", "GetTemplateSummary");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTemplateSummaryRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)getTemplateSummaryRequest.templateBody()));
        }
        if (getTemplateSummaryRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)getTemplateSummaryRequest.templateURL()));
        }
        if (getTemplateSummaryRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)getTemplateSummaryRequest.stackName()));
        }
        if (getTemplateSummaryRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)getTemplateSummaryRequest.stackSetName()));
        }
        return request;
    }
}

