/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;

public class DescribeStackEventsRequestMarshaller
implements Marshaller<Request<DescribeStackEventsRequest>, DescribeStackEventsRequest> {
    public Request<DescribeStackEventsRequest> marshall(DescribeStackEventsRequest describeStackEventsRequest) {
        if (describeStackEventsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeStackEventsRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackEvents");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackEventsRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)describeStackEventsRequest.stackName()));
        }
        if (describeStackEventsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeStackEventsRequest.nextToken()));
        }
        return request;
    }
}

