/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;

public class DeleteStackRequestMarshaller
implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {
    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {
        if (deleteStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteStackRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)deleteStackRequest.stackName()));
        }
        if (deleteStackRequest.retainResources().isEmpty() && !(deleteStackRequest.retainResources() instanceof SdkAutoConstructList)) {
            request.addParameter("RetainResources", "");
        } else if (!deleteStackRequest.retainResources().isEmpty() && !(deleteStackRequest.retainResources() instanceof SdkAutoConstructList)) {
            List<String> retainResourcesList = deleteStackRequest.retainResources();
            int retainResourcesListIndex = 1;
            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex, StringConversion.fromString((String)retainResourcesListValue));
                }
                ++retainResourcesListIndex;
            }
        }
        if (deleteStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString((String)deleteStackRequest.roleARN()));
        }
        if (deleteStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString((String)deleteStackRequest.clientRequestToken()));
        }
        return request;
    }
}

