/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateChangeSetRequestMarshaller
implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {
    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {
        RollbackConfiguration rollbackConfiguration;
        if (createChangeSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)createChangeSetRequest.stackName()));
        }
        if (createChangeSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)createChangeSetRequest.templateBody()));
        }
        if (createChangeSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)createChangeSetRequest.templateURL()));
        }
        if (createChangeSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringConversion.fromBoolean((Boolean)createChangeSetRequest.usePreviousTemplate()));
        }
        if (createChangeSetRequest.parameters().isEmpty() && !(createChangeSetRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!createChangeSetRequest.parameters().isEmpty() && !(createChangeSetRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = createChangeSetRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringConversion.fromString((String)parametersListValue.parameterKey()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        if (createChangeSetRequest.capabilitiesAsStrings().isEmpty() && !(createChangeSetRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!createChangeSetRequest.capabilitiesAsStrings().isEmpty() && !(createChangeSetRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> capabilitiesList = createChangeSetRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringConversion.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (createChangeSetRequest.resourceTypes().isEmpty() && !(createChangeSetRequest.resourceTypes() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceTypes", "");
        } else if (!createChangeSetRequest.resourceTypes().isEmpty() && !(createChangeSetRequest.resourceTypes() instanceof SdkAutoConstructList)) {
            List<String> resourceTypesList = createChangeSetRequest.resourceTypes();
            int resourceTypesListIndex = 1;
            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringConversion.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (createChangeSetRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString((String)createChangeSetRequest.roleARN()));
        }
        if ((rollbackConfiguration = createChangeSetRequest.rollbackConfiguration()) != null) {
            if (rollbackConfiguration.rollbackTriggers().isEmpty() && !(rollbackConfiguration.rollbackTriggers() instanceof SdkAutoConstructList)) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            } else if (!rollbackConfiguration.rollbackTriggers().isEmpty() && !(rollbackConfiguration.rollbackTriggers() instanceof SdkAutoConstructList)) {
                List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
                int rollbackTriggersListIndex = 1;
                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {
                    if (rollbackTriggersListValue.arn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringConversion.fromString((String)rollbackTriggersListValue.arn()));
                    }
                    if (rollbackTriggersListValue.type() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringConversion.fromString((String)rollbackTriggersListValue.type()));
                    }
                    ++rollbackTriggersListIndex;
                }
            }
            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringConversion.fromInteger((Integer)rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }
        if (createChangeSetRequest.notificationARNs().isEmpty() && !(createChangeSetRequest.notificationARNs() instanceof SdkAutoConstructList)) {
            request.addParameter("NotificationARNs", "");
        } else if (!createChangeSetRequest.notificationARNs().isEmpty() && !(createChangeSetRequest.notificationARNs() instanceof SdkAutoConstructList)) {
            List<String> notificationARNsList = createChangeSetRequest.notificationARNs();
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringConversion.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (createChangeSetRequest.tags().isEmpty() && !(createChangeSetRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createChangeSetRequest.tags().isEmpty() && !(createChangeSetRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createChangeSetRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringConversion.fromString((String)createChangeSetRequest.changeSetName()));
        }
        if (createChangeSetRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createChangeSetRequest.clientToken()));
        }
        if (createChangeSetRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createChangeSetRequest.description()));
        }
        if (createChangeSetRequest.changeSetTypeAsString() != null) {
            request.addParameter("ChangeSetType", StringConversion.fromString((String)createChangeSetRequest.changeSetTypeAsString()));
        }
        return request;
    }
}

