/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;

public class ContinueUpdateRollbackRequestMarshaller
implements Marshaller<Request<ContinueUpdateRollbackRequest>, ContinueUpdateRollbackRequest> {
    public Request<ContinueUpdateRollbackRequest> marshall(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        if (continueUpdateRollbackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)continueUpdateRollbackRequest, "CloudFormationClient");
        request.addParameter("Action", "ContinueUpdateRollback");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (continueUpdateRollbackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)continueUpdateRollbackRequest.stackName()));
        }
        if (continueUpdateRollbackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString((String)continueUpdateRollbackRequest.roleARN()));
        }
        if (continueUpdateRollbackRequest.resourcesToSkip().isEmpty() && !(continueUpdateRollbackRequest.resourcesToSkip() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourcesToSkip", "");
        } else if (!continueUpdateRollbackRequest.resourcesToSkip().isEmpty() && !(continueUpdateRollbackRequest.resourcesToSkip() instanceof SdkAutoConstructList)) {
            List<String> resourcesToSkipList = continueUpdateRollbackRequest.resourcesToSkip();
            int resourcesToSkipListIndex = 1;
            for (String resourcesToSkipListValue : resourcesToSkipList) {
                if (resourcesToSkipListValue != null) {
                    request.addParameter("ResourcesToSkip.member." + resourcesToSkipListIndex, StringConversion.fromString((String)resourcesToSkipListValue));
                }
                ++resourcesToSkipListIndex;
            }
        }
        if (continueUpdateRollbackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString((String)continueUpdateRollbackRequest.clientRequestToken()));
        }
        return request;
    }
}

