/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTerminationProtectionRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, UpdateTerminationProtectionRequest> {
    private final Boolean enableTerminationProtection;
    private final String stackName;

    private UpdateTerminationProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.stackName = builder.stackName;
    }

    public Boolean enableTerminationProtection() {
        return this.enableTerminationProtection;
    }

    public String stackName() {
        return this.stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTerminationProtectionRequest)) {
            return false;
        }
        UpdateTerminationProtectionRequest other = (UpdateTerminationProtectionRequest)((Object)obj);
        return Objects.equals(this.enableTerminationProtection(), other.enableTerminationProtection()) && Objects.equals(this.stackName(), other.stackName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTerminationProtectionRequest").add("EnableTerminationProtection", (Object)this.enableTerminationProtection()).add("StackName", (Object)this.stackName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableTerminationProtection": {
                return Optional.ofNullable(clazz.cast(this.enableTerminationProtection()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private Boolean enableTerminationProtection;
        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTerminationProtectionRequest model) {
            super(model);
            this.enableTerminationProtection(model.enableTerminationProtection);
            this.stackName(model.stackName);
        }

        public final Boolean getEnableTerminationProtection() {
            return this.enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTerminationProtectionRequest build() {
            return new UpdateTerminationProtectionRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, UpdateTerminationProtectionRequest> {
        public Builder enableTerminationProtection(Boolean var1);

        public Builder stackName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

