/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.StackInstance;

public class StackInstanceUnmarshaller
implements Unmarshaller<StackInstance, StaxUnmarshallerContext> {
    private static final StackInstanceUnmarshaller INSTANCE = new StackInstanceUnmarshaller();

    public StackInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StackInstance.Builder stackInstance = StackInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackSetId", targetDepth)) {
                    stackInstance.stackSetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Region", targetDepth)) {
                    stackInstance.region(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Account", targetDepth)) {
                    stackInstance.account(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackId", targetDepth)) {
                    stackInstance.stackId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    stackInstance.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StatusReason", targetDepth)) continue;
                stackInstance.statusReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StackInstance)stackInstance.build();
    }

    public static StackInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

