/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateChangeSetRequestMarshaller
implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {
        List<Tag> tagsList;
        List<String> list;
        RollbackConfiguration rollbackConfiguration;
        List<String> resourceTypesList;
        List<String> capabilitiesList;
        List<Parameter> parametersList;
        if (createChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createChangeSetRequest.stackName()));
        }
        if (createChangeSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createChangeSetRequest.templateBody()));
        }
        if (createChangeSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createChangeSetRequest.templateURL()));
        }
        if (createChangeSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)createChangeSetRequest.usePreviousTemplate()));
        }
        if ((parametersList = createChangeSetRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if ((capabilitiesList = createChangeSetRequest.capabilitiesAsStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String string : capabilitiesList) {
                    if (string != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)string));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((resourceTypesList = createChangeSetRequest.resourceTypes()) != null) {
            if (!resourceTypesList.isEmpty()) {
                boolean bl = true;
                for (String resourceTypesListValue : resourceTypesList) {
                    void var6_12;
                    if (resourceTypesListValue != null) {
                        request.addParameter("ResourceTypes.member." + (int)var6_12, StringUtils.fromString((String)resourceTypesListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }
        if (createChangeSetRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createChangeSetRequest.roleARN()));
        }
        if ((rollbackConfiguration = createChangeSetRequest.rollbackConfiguration()) != null) {
            List<RollbackTrigger> list2 = rollbackConfiguration.rollbackTriggers();
            if (list2 != null) {
                if (!list2.isEmpty()) {
                    int rollbackTriggersListIndex = 1;
                    for (RollbackTrigger rollbackTriggersListValue : list2) {
                        if (rollbackTriggersListValue.arn() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringUtils.fromString((String)rollbackTriggersListValue.arn()));
                        }
                        if (rollbackTriggersListValue.type() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringUtils.fromString((String)rollbackTriggersListValue.type()));
                        }
                        ++rollbackTriggersListIndex;
                    }
                } else {
                    request.addParameter("RollbackConfiguration.RollbackTriggers", "");
                }
            }
            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringUtils.fromInteger((Integer)rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }
        if ((list = createChangeSetRequest.notificationARNs()) != null) {
            if (!list.isEmpty()) {
                int notificationARNsListIndex = 1;
                for (String notificationARNsListValue : list) {
                    if (notificationARNsListValue != null) {
                        request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                    }
                    ++notificationARNsListIndex;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }
        if ((tagsList = createChangeSetRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)createChangeSetRequest.changeSetName()));
        }
        if (createChangeSetRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createChangeSetRequest.clientToken()));
        }
        if (createChangeSetRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createChangeSetRequest.description()));
        }
        if (createChangeSetRequest.changeSetTypeAsString() != null) {
            request.addParameter("ChangeSetType", StringUtils.fromString((String)createChangeSetRequest.changeSetTypeAsString()));
        }
        return request;
    }
}

