/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public class DescribeStackEventsPublisher
implements SdkPublisher<DescribeStackEventsResponse> {
    private final CloudFormationAsyncClient client;
    private final DescribeStackEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStackEventsPublisher(CloudFormationAsyncClient client, DescribeStackEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStackEventsPublisher(CloudFormationAsyncClient client, DescribeStackEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStackEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStackEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<StackEvent> stackEvents() {
        Function<DescribeStackEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackEvents() != null) {
                return response.stackEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeStackEventsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeStackEventsPublisher resume(DescribeStackEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeStackEventsPublisher(this.client, (DescribeStackEventsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeStackEventsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeStackEventsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeStackEventsResponseFetcher
    implements AsyncPageFetcher<DescribeStackEventsResponse> {
        private DescribeStackEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackEventsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeStackEventsResponse> nextPage(DescribeStackEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackEventsPublisher.this.client.describeStackEvents(DescribeStackEventsPublisher.this.firstRequest);
            }
            return DescribeStackEventsPublisher.this.client.describeStackEvents((DescribeStackEventsRequest)((Object)DescribeStackEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

