/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackResourceDetail
implements ToCopyableBuilder<Builder, StackResourceDetail> {
    private final String stackName;
    private final String stackId;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant lastUpdatedTimestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final String description;
    private final String metadata;

    private StackResourceDetail(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.stackId = builder.stackId;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.description = builder.description;
        this.metadata = builder.metadata;
    }

    public String stackName() {
        return this.stackName;
    }

    public String stackId() {
        return this.stackId;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public String description() {
        return this.description;
    }

    public String metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceDetail)) {
            return false;
        }
        StackResourceDetail other = (StackResourceDetail)obj;
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.metadata(), other.metadata());
    }

    public String toString() {
        return ToString.builder((String)"StackResourceDetail").add("StackName", (Object)this.stackName()).add("StackId", (Object)this.stackId()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).add("Description", (Object)this.description()).add("Metadata", (Object)this.metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "LogicalResourceId": {
                return Optional.of(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.of(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.of(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "ResourceStatus": {
                return Optional.of(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.of(clazz.cast(this.resourceStatusReason()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String stackId;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant lastUpdatedTimestamp;
        private String resourceStatus;
        private String resourceStatusReason;
        private String description;
        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceDetail model) {
            this.stackName(model.stackName);
            this.stackId(model.stackId);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.description(model.description);
            this.metadata(model.metadata);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public StackResourceDetail build() {
            return new StackResourceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackResourceDetail> {
        public Builder stackName(String var1);

        public Builder stackId(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder description(String var1);

        public Builder metadata(String var1);
    }
}

