/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.transform.OutputUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ParameterUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.TagUnmarshaller;

public class StackUnmarshaller
implements Unmarshaller<Stack, StaxUnmarshallerContext> {
    private static StackUnmarshaller INSTANCE;

    public Stack unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Stack.Builder stack = Stack.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackId", targetDepth)) {
                    stack.stackId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackName", targetDepth)) {
                    stack.stackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ChangeSetId", targetDepth)) {
                    stack.changeSetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    stack.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    stack.parameters(new ArrayList<Parameter>());
                    continue;
                }
                if (context.testExpression("Parameters/member", targetDepth)) {
                    stack.parameters(ParameterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    stack.creationTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastUpdatedTime", targetDepth)) {
                    stack.lastUpdatedTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackStatus", targetDepth)) {
                    stack.stackStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackStatusReason", targetDepth)) {
                    stack.stackStatusReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DisableRollback", targetDepth)) {
                    stack.disableRollback(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NotificationARNs", targetDepth)) {
                    stack.notificationARNs(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("NotificationARNs/member", targetDepth)) {
                    stack.notificationARNs(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TimeoutInMinutes", targetDepth)) {
                    stack.timeoutInMinutes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Capabilities", targetDepth)) {
                    stack.capabilities(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Capabilities/member", targetDepth)) {
                    stack.capabilities(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Outputs", targetDepth)) {
                    stack.outputs(new ArrayList<Output>());
                    continue;
                }
                if (context.testExpression("Outputs/member", targetDepth)) {
                    stack.outputs(OutputUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    stack.roleARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    stack.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/member", targetDepth)) continue;
                stack.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Stack)stack.build();
    }

    public static StackUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StackUnmarshaller();
        }
        return INSTANCE;
    }
}

