/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackResourceSummary
implements ToCopyableBuilder<Builder, StackResourceSummary> {
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Date lastUpdatedTimestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;

    private StackResourceSummary(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Date lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public String resourceStatus() {
        return this.resourceStatus;
    }

    public String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logicalResourceId() == null ? 0 : this.logicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.physicalResourceId() == null ? 0 : this.physicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTimestamp() == null ? 0 : this.lastUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.resourceStatus() == null ? 0 : this.resourceStatus().hashCode());
        hashCode = 31 * hashCode + (this.resourceStatusReason() == null ? 0 : this.resourceStatusReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceSummary)) {
            return false;
        }
        StackResourceSummary other = (StackResourceSummary)obj;
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.lastUpdatedTimestamp() == null ^ this.lastUpdatedTimestamp() == null) {
            return false;
        }
        if (other.lastUpdatedTimestamp() != null && !other.lastUpdatedTimestamp().equals(this.lastUpdatedTimestamp())) {
            return false;
        }
        if (other.resourceStatus() == null ^ this.resourceStatus() == null) {
            return false;
        }
        if (other.resourceStatus() != null && !other.resourceStatus().equals(this.resourceStatus())) {
            return false;
        }
        if (other.resourceStatusReason() == null ^ this.resourceStatusReason() == null) {
            return false;
        }
        return other.resourceStatusReason() == null || other.resourceStatusReason().equals(this.resourceStatusReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.logicalResourceId()).append(",");
        }
        if (this.physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.physicalResourceId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.lastUpdatedTimestamp() != null) {
            sb.append("LastUpdatedTimestamp: ").append(this.lastUpdatedTimestamp()).append(",");
        }
        if (this.resourceStatus() != null) {
            sb.append("ResourceStatus: ").append(this.resourceStatus()).append(",");
        }
        if (this.resourceStatusReason() != null) {
            sb.append("ResourceStatusReason: ").append(this.resourceStatusReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Date lastUpdatedTimestamp;
        private String resourceStatus;
        private String resourceStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceSummary model) {
            this.setLogicalResourceId(model.logicalResourceId);
            this.setPhysicalResourceId(model.physicalResourceId);
            this.setResourceType(model.resourceType);
            this.setLastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.setResourceStatus(model.resourceStatus);
            this.setResourceStatusReason(model.resourceStatusReason);
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Date getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Date lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = StandardMemberCopier.copy((Date)lastUpdatedTimestamp);
            return this;
        }

        public final void setLastUpdatedTimestamp(Date lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = StandardMemberCopier.copy((Date)lastUpdatedTimestamp);
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final void setResourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public StackResourceSummary build() {
            return new StackResourceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackResourceSummary> {
        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder lastUpdatedTimestamp(Date var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);
    }
}

