/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudformation.model.ChangeAction;
import software.amazon.awssdk.services.cloudformation.model.Replacement;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetailsCopier;
import software.amazon.awssdk.services.cloudformation.model.ScopeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceChange
implements ToCopyableBuilder<Builder, ResourceChange> {
    private final String action;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final String replacement;
    private final List<String> scope;
    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    public String action() {
        return this.action;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String replacement() {
        return this.replacement;
    }

    public List<String> scope() {
        return this.scope;
    }

    public List<ResourceChangeDetail> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.logicalResourceId() == null ? 0 : this.logicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.physicalResourceId() == null ? 0 : this.physicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.replacement() == null ? 0 : this.replacement().hashCode());
        hashCode = 31 * hashCode + (this.scope() == null ? 0 : this.scope().hashCode());
        hashCode = 31 * hashCode + (this.details() == null ? 0 : this.details().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.replacement() == null ^ this.replacement() == null) {
            return false;
        }
        if (other.replacement() != null && !other.replacement().equals(this.replacement())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        return other.details() == null || other.details().equals(this.details());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.logicalResourceId()).append(",");
        }
        if (this.physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.physicalResourceId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.replacement() != null) {
            sb.append("Replacement: ").append(this.replacement()).append(",");
        }
        if (this.scope() != null) {
            sb.append("Scope: ").append(this.scope()).append(",");
        }
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private String replacement;
        private List<String> scope = new SdkInternalList();
        private List<ResourceChangeDetail> details = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            this.setAction(model.action);
            this.setLogicalResourceId(model.logicalResourceId);
            this.setPhysicalResourceId(model.physicalResourceId);
            this.setResourceType(model.resourceType);
            this.setReplacement(model.replacement);
            this.setScope(model.scope);
            this.setDetails(model.details);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ChangeAction action) {
            this.action(action.toString());
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getReplacement() {
            return this.replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement.toString());
            return this;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public final void setReplacement(Replacement replacement) {
            this.replacement(replacement.toString());
        }

        public final Collection<String> getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String ... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList(scope.length);
            }
            for (String e : scope) {
                this.scope.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(ResourceAttribute ... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList(scope.length);
            }
            for (ResourceAttribute ele : scope) {
                this.scope.add(ele.toString());
            }
            return this;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        @SafeVarargs
        public final void setScope(String ... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList(scope.length);
            }
            for (String e : scope) {
                this.scope.add(e);
            }
        }

        @SafeVarargs
        public final void setScope(ResourceAttribute ... scope) {
            if (this.scope == null) {
                this.scope = new SdkInternalList(scope.length);
            }
            for (ResourceAttribute ele : scope) {
                this.scope.add(ele.toString());
            }
        }

        public final Collection<ResourceChangeDetail> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail ... details) {
            if (this.details == null) {
                this.details = new SdkInternalList(details.length);
            }
            for (ResourceChangeDetail e : details) {
                this.details.add(e);
            }
            return this;
        }

        public final void setDetails(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
        }

        @SafeVarargs
        public final void setDetails(ResourceChangeDetail ... details) {
            if (this.details == null) {
                this.details = new SdkInternalList(details.length);
            }
            for (ResourceChangeDetail e : details) {
                this.details.add(e);
            }
        }

        public ResourceChange build() {
            return new ResourceChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceChange> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder replacement(String var1);

        public Builder replacement(Replacement var1);

        public Builder scope(Collection<String> var1);

        public Builder scope(String ... var1);

        public Builder scope(ResourceAttribute ... var1);

        public Builder details(Collection<ResourceChangeDetail> var1);

        public Builder details(ResourceChangeDetail ... var1);
    }
}

